/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.RedstoneInterface;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class WaitRedstoneInstruction
implements PlcInstruction {
    private final WaitAction action = new WaitAction();
    private final Supplier<class_1937> worldSupplier;
    private final LazyBlockApiCache<RedstoneInterface, class_2350> redstoneCache;
    private final Argument target;

    public WaitRedstoneInstruction(Supplier<class_1937> worldSupplier, Argument target) {
        this.target = target;
        this.worldSupplier = worldSupplier;
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, worldSupplier, this.target);
    }

    public WaitRedstoneInstruction(Supplier<class_1937> worldSupplier, class_2487 nbt) {
        this.target = Argument.fromNbt(nbt.method_10562("target"));
        this.worldSupplier = worldSupplier;
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, worldSupplier, this.target);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        plc.addRobotAction(this.action, this::finish);
    }

    private void finish(PLC plc) {
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.WAIT_REDSTONE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String s) throws NeepASM.ParseException {
        view.fastForward();
        Argument target = parser.parseWorldTarget(view);
        if (target == null) {
            throw new NeepASM.ParseException("expected redstone target");
        }
        return (world, source, program) -> program.addBack(new WaitRedstoneInstruction(() -> world, target));
    }

    class WaitAction
    implements RobotAction {
        WaitAction() {
        }

        @Override
        public boolean finished(PLC plc) {
            RedstoneInterface redstone;
            if (WaitRedstoneInstruction.this.worldSupplier.get().method_8510() % 2L == 0L && (redstone = WaitRedstoneInstruction.this.redstoneCache.find()) != null) {
                return redstone.getReceivedStrength() > 0;
            }
            return false;
        }

        @Override
        public void start(PLC plc) {
        }

        @Override
        public void tick(PLC plc) {
        }

        @Override
        public void end(PLC plc) {
        }
    }
}

