/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.transport.block.item_transport.entity.PipeDriverBlockEntity;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StockInstruction
implements PlcInstruction {
    private final Pattern pattern;

    public StockInstruction(Supplier<class_1937> worldSupplier, String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public StockInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, nbt.method_10558("pattern"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("pattern", this.pattern.pattern());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        DataStack stack = plc.dataStack();
        PLCActuator pLCActuator = plc.getActuator();
        if (pLCActuator instanceof PipeDriverBlockEntity) {
            PipeDriverBlockEntity be = (PipeDriverBlockEntity)pLCActuator;
            try (Transaction transaction = Transaction.openOuter();){
                Predicate<ItemVariant> predicate = v -> Instructions.match(this.pattern, v.getItem());
                stack.push(Math.toIntExact(be.getNetwork(null).getAllAvailable(predicate, (TransactionContext)transaction).mapToLong(ResourceAmount::amount).sum()));
                transaction.abort();
            }
        } else {
            throw new NeepASM.RuntimeException("STOCK: Actuator is not a pipe driver");
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.REQUEST;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String s) throws NeepASM.ParseException {
        view.fastForward();
        String regex = Instructions.parseRegistryGlob(view, class_7923.field_41178, "item");
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new StockInstruction(() -> world, regex));
    }
}

