/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class SHRInstruction
implements PlcInstruction {
    private final int shift;

    public SHRInstruction(int shift) {
        this.shift = shift;
    }

    public SHRInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this.shift = nbt.method_10550("shift");
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        DataStack stack = plc.dataStack();
        DataStack.Entry entry = stack.pop();
        stack.push(entry.value() >>> this.shift, entry.pointer());
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.SHR;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String scope) throws NeepASM.ParseException {
        view.fastForward();
        if (!NeepAsmTokenView.isDigit(view.peek())) {
            throw new NeepASM.ParseException("expected shift integer");
        }
        int shift = view.nextInteger();
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new SHRInstruction(shift));
    }
}

