/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RisingEdgeInstruction
implements Instruction {
    private int prevValue;

    public RisingEdgeInstruction(class_2487 nbt) {
        this.prevValue = nbt.method_10550("prev_value");
    }

    public RisingEdgeInstruction() {
        this.prevValue = 0;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10569("prev_value", this.prevValue);
        return nbt;
    }

    @Override
    public void start(VM plc) throws NeepASM.RuntimeException {
        DataStack dataStack = plc.dataStack();
        int newValue = dataStack.popInt();
        if (this.prevValue <= 0 && newValue > 0) {
            dataStack.push(-1);
        } else {
            dataStack.push(0);
        }
        this.prevValue = newValue;
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.RISING_EDGE;
    }

    public static ParsedInstruction parser(NeepAsmTokenView neepAsmTokenView, NeepAsmParser neepAsmParser, @Nullable String s) {
        return (labelLookup, program) -> new RisingEdgeInstruction();
    }
}

