/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.api.plc.robot.GroupedRobotAction;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.recipe.ItemWorkpiece;
import com.neep.neepmeat.plc.robot.RobotMoveToAction;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class RemoveInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final Argument from;

    public RemoveInstruction(Supplier<class_1937> world, List<Argument> arguments) {
        this.world = world;
        this.from = arguments.get(0);
    }

    public RemoveInstruction(Supplier<class_1937> world, class_2487 compound) {
        this.world = world;
        this.from = Argument.fromNbt(compound.method_10562("target"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.from.toNbt());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        plc.addRobotAction(GroupedRobotAction.of(new RobotMoveToAction(this.from.pos())), this::finish);
    }

    private void finish(PLC plc) {
        MutateInPlace mip = (MutateInPlace)MutateInPlace.ITEM.find(this.world.get(), this.from.pos(), null);
        if (mip == null) {
            mip = (MutateInPlace)MutateInPlace.ENTITY.find(this.world.get(), this.from.pos(), null);
        }
        if (mip != null) {
            Workpiece workpiece;
            class_1799 stack;
            Object object = mip.get();
            if (object instanceof class_1799 && !ItemWorkpiece.has(stack = (class_1799)object)) {
                return;
            }
            if (object != null && (workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable(object)) != null && workpiece.getSteps().size() > 0) {
                workpiece.removeStep(workpiece.getSteps().size() - 1);
            }
            mip.setResult(1, object);
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.REMOVE;
    }
}

