/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.RedstoneInterface;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class ReadRedstoneInstruction
implements PlcInstruction {
    private final Argument target;
    private final LazyBlockApiCache<RedstoneInterface, class_2350> redstoneCache;

    public ReadRedstoneInstruction(Supplier<class_1937> world, Argument argument) {
        this.target = argument;
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, world, this.target);
    }

    public ReadRedstoneInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this.target = Argument.fromNbt(nbt.method_10562("target"));
        this.redstoneCache = LazyBlockApiCache.of(RedstoneInterface.LOOKUP, world, this.target);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        RedstoneInterface redstone = this.redstoneCache.find();
        if (redstone != null) {
            plc.dataStack().push(redstone.getReceivedStrength());
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.READ_REDSTONE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String s) throws NeepASM.ParseException {
        view.fastForward();
        Argument target = parser.parseWorldTarget(view);
        if (target == null) {
            throw new NeepASM.ParseException("expected redstone target");
        }
        return (world, source, program) -> program.addBack(new ReadRedstoneInstruction(() -> world, target));
    }
}

