/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.memory.MemoryManager;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeepBusWriteInstruction
implements PlcInstruction {
    @Nullable
    private final String address;

    public NeepBusWriteInstruction(Supplier<class_1937> worldSupplier, class_2487 nbt) {
        this(nbt.method_10545("address") ? nbt.method_10558("address") : null);
    }

    public NeepBusWriteInstruction(@Nullable String address) {
        this.address = address;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        if (this.address != null) {
            nbt.method_10582("address", this.address);
        }
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (plc instanceof PLCBlockEntity) {
            DataStack.Entry entry;
            PLCBlockEntity be = (PLCBlockEntity)plc;
            MemoryManager memory = plc.getMemory();
            String usedAddress = this.address;
            if (this.address == null) {
                usedAddress = memory.fetch(plc.dataStack().pop().value()).toDataVariant().stringValue();
            }
            if ((entry = plc.dataStack().pop()).pointer()) {
                MemoryEntry memoryData = plc.getMemory().fetch(entry.value());
                be.getSender().send(usedAddress, memoryData.toDataVariant());
            } else {
                be.getSender().send(usedAddress, DataVariant.of(entry.value()));
            }
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.NEEPBUS_WRITE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String s) throws NeepASM.ParseException {
        String address = view.nextString();
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new NeepBusWriteInstruction(address));
    }
}

