/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.robot.AtomicAction;
import com.neep.neepmeat.api.plc.robot.GroupedRobotAction;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.CombineActuator;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.plc.robot.RobotMoveToAction;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MoveInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final GroupedRobotAction group;
    private final Argument from;
    private final Argument to;
    private final int amount;
    private final Pattern pattern;
    private ResourceAmount<ItemVariant> stored;

    public MoveInstruction(Supplier<class_1937> world, List<Argument> arguments) {
        this(world, arguments.get(0), arguments.get(1), 64, ".*");
    }

    public MoveInstruction(Supplier<class_1937> world, Argument from, Argument to, int count, String regex) {
        this.world = world;
        this.from = from;
        this.to = to;
        this.amount = count;
        this.pattern = Pattern.compile(regex);
        this.group = GroupedRobotAction.of(new RobotMoveToAction(from.pos()), AtomicAction.of(this::takeFirst), new RobotMoveToAction(to.pos()), AtomicAction.of(this::complete));
    }

    public MoveInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, Argument.fromNbt(nbt.method_10562("from")), Argument.fromNbt(nbt.method_10562("to")), nbt.method_10550("amount"), nbt.method_10545("regex") ? nbt.method_10558("regex") : ".*");
        this.group.readNbt(nbt.method_10562("action"));
        this.stored = PlcInstruction.readItem(nbt.method_10562("stored"));
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("from", (class_2520)this.from.toNbt());
        nbt.method_10566("to", (class_2520)this.to.toNbt());
        nbt.method_10566("action", (class_2520)this.group.writeNbt(new class_2487()));
        nbt.method_10566("stored", (class_2520)PlcInstruction.writeItem(this.stored));
        nbt.method_10569("amount", this.amount);
        nbt.method_10582("regex", this.pattern.pattern());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (!(plc.getActuator() instanceof CombineActuator)) {
            throw NeepASM.RuntimeException.notSupported("MOVE");
        }
        plc.addRobotAction(this.group, this::finish);
    }

    @Override
    public void cancel(PLC plc) {
        if (this.stored != null) {
            plc.controlActuator(a -> a.spawnItem(this.stored));
        }
        this.group.end(plc);
        this.stored = null;
    }

    private void takeFirst(PLC plc) throws NeepASM.RuntimeException {
        this.stored = Instructions.takeItem(this.from, this.world, this.amount, this.pattern);
        if (this.stored == null) {
            this.group.setFinished(plc);
            plc.dataStack().push(0);
            plc.advanceCounter();
        } else {
            PLCActuator robot = plc.getActuator();
            this.world.get().method_47967(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.EXTRACT_ITEM, class_3419.field_15245, 1.0f, 1.0f, 1L);
        }
    }

    private void complete(PLC plc) throws NeepASM.RuntimeException {
        Storage storage = (Storage)ItemStorage.SIDED.find(this.world.get(), this.to.pos(), (Object)this.to.face());
        if (this.stored != null && storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = storage.insert((Object)((ItemVariant)this.stored.resource()), this.stored.amount(), (TransactionContext)transaction);
                if (inserted == this.stored.amount()) {
                    transaction.commit();
                    PLCActuator robot = plc.getActuator();
                    this.world.get().method_47967(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.INSERT_ITEM, class_3419.field_15245, 1.0f, 1.0f, 1L);
                    this.stored = null;
                    plc.dataStack().push(-1);
                    return;
                }
                transaction.abort();
            }
        }
        plc.getActuator().spawnItem(this.stored);
        this.stored = null;
    }

    private void finish(PLC plc) throws NeepASM.RuntimeException {
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.MOVE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser) throws NeepASM.ParseException {
        view.fastForward();
        Argument from = parser.parseWorldTarget(view);
        if (from == null) {
            throw new NeepASM.ParseException("expected source world target");
        }
        view.fastForward();
        Argument to = parser.parseWorldTarget(view);
        if (to == null) {
            throw new NeepASM.ParseException("expected destination world target");
        }
        view.fastForward();
        int count = NeepAsmTokenView.isDigit(view.peek()) ? view.nextInteger() : 64;
        view.fastForward();
        String regex = view.peek() == '\"' ? Instructions.parseRegistryGlob(view, class_7923.field_41178, "item") : ".*";
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> program.addBack(new MoveInstruction(() -> world, from, to, count, regex));
    }
}

