/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.interrupt.InterruptEmitter;
import com.neep.neepmeat.api.plc.interrupt.InterruptReceiver;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.ParsedSource;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class InterruptHandlerInstruction
implements PlcInstruction {
    private final Supplier<class_1937> worldSupplier;
    private final Argument target;
    private final Label label;

    public InterruptHandlerInstruction(Supplier<class_1937> worldSupplier, class_2487 nbt) {
        this(worldSupplier, Argument.fromNbt(nbt.method_10562("target")), new Label(nbt.method_10558("label_name"), nbt.method_10550("label_index")));
    }

    public InterruptHandlerInstruction(Supplier<class_1937> worldSupplier, Argument target, Label label) {
        this.worldSupplier = worldSupplier;
        this.target = target;
        this.label = label;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        nbt.method_10582("label_name", this.label.name());
        nbt.method_10569("label_index", this.label.index());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (plc instanceof InterruptReceiver) {
            InterruptReceiver interruptReceiver = (InterruptReceiver)plc;
            if (this.worldSupplier.get().method_8321(this.target.pos()) instanceof InterruptEmitter) {
                interruptReceiver.getInterrupts().put(this.target.pos(), this.label);
            } else {
                throw new NeepASM.RuntimeException("IHANDLER: Target does not emit interrupts");
            }
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.IHANDLER;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String scope) throws NeepASM.ParseException {
        view.fastForward();
        Argument target = parser.parseWorldTarget(view);
        if (target == null) {
            throw new NeepASM.ParseException("expected world target");
        }
        view.fastForward();
        String id = view.nextIdentifier();
        if (id.isEmpty()) {
            throw new NeepASM.ParseException("expected label");
        }
        String label = ParsedSource.mangleLabel(id, scope);
        parser.assureLineEnd(view);
        return (world, parsedSource1, program) -> {
            Label l = parsedSource1.findLabel(label, program.size(), Label.Seek.ABSOLUTE);
            if (l == null) {
                throw new NeepASM.CompilationException("label '" + label + "' does not exist");
            }
            program.addBack(new InterruptHandlerInstruction(() -> world, target, l));
        };
    }
}

