/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.program.MutableProgram;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import com.neep.neepmeat.plc.block.entity.PLCExecutor;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final Argument target;
    private final Instruction instruction;

    public ExecInstruction(Supplier<class_1937> world, @Nullable Argument target, Instruction instruction) {
        this.world = world;
        this.target = target;
        this.instruction = instruction;
    }

    public ExecInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this.world = world;
        this.target = Argument.fromNbt(nbt.method_10562("target"));
        class_2487 instructionNbt = nbt.method_10562("instruction");
        String id = instructionNbt.method_10558("id");
        InstructionProvider provider = Instructions.REGISTRY.get(id);
        this.instruction = provider != null ? provider.createFromNbt(world, instructionNbt) : EMPTY;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 instructionNbt = new class_2487();
        instructionNbt.method_10582("id", this.instruction.getOpcode().getParseName());
        this.instruction.writeNbt(instructionNbt);
        nbt.method_10566("instruction", (class_2520)instructionNbt);
        nbt.method_10566("target", (class_2520)this.target.toNbt());
        return nbt;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (plc instanceof PLCBlockEntity) {
            PLCBlockEntity pbe = (PLCBlockEntity)plc;
            class_2586 class_25862 = pbe.method_10997().method_8321(this.target.pos());
            if (class_25862 instanceof PLCExecutor) {
                PLCExecutor executor = (PLCExecutor)class_25862;
                executor.receiveInstruction(this.instruction.getOpcode().createFromNbt(this.world, this.instruction.writeNbt(new class_2487())));
            }
        } else {
            throw new NeepASM.RuntimeException("Exec not supported");
        }
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.EXEC;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String scope) throws NeepASM.ParseException {
        view.fastForward();
        Argument target = parser.parseWorldTarget(view);
        if (target == null) {
            throw new NeepASM.ParseException("expected argument after exec");
        }
        ParsedInstruction parsedInstruction = parser.parseInstruction(view, null);
        if (parsedInstruction == null) {
            throw new NeepASM.ParseException("expected instruction after exec");
        }
        return (world, source, program) -> {
            DummyProgram dummyProgram = new DummyProgram();
            PlcParsedInstruction.build(world, parsedInstruction, source, dummyProgram);
            Instruction instruction = dummyProgram.get(0);
            if (instruction == EMPTY) {
                throw new NeepASM.CompilationException("exec instruction is empty");
            }
            if (instruction.getOpcode().equals(Instructions.EXEC)) {
                throw new NeepASM.CompilationException("nested exec instructions not allowed");
            }
            program.addBack(new ExecInstruction(() -> world, target, instruction));
        };
    }

    private static class DummyProgram
    implements MutableProgram {
        public List<Instruction> instructions = Lists.newArrayList();

        private DummyProgram() {
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            return nbt;
        }

        @Override
        public void readNbt(class_2487 nbt) {
        }

        @Override
        public void addBack(Instruction instruction) {
            this.instructions.add(instruction);
        }

        @Override
        public void setDebugLine(int line) {
        }

        @Override
        public Instruction get(int index) {
            if (index < this.instructions.size()) {
                return this.instructions.get(index);
            }
            return Instruction.end();
        }

        @Override
        public int size() {
            return this.instructions.size();
        }

        @Override
        public int getDebugLine(int counter) {
            return -1;
        }
    }
}

