/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.api.plc.robot.AtomicAction;
import com.neep.neepmeat.api.plc.robot.GroupedRobotAction;
import com.neep.neepmeat.api.plc.robot.SoundAction;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.item.ItemImplantItem;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.network.ParticleSpawnS2C;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.block.entity.CombineActuator;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.recipe.CombineStep;
import com.neep.neepmeat.plc.recipe.ItemManufactureRecipe;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.plc.robot.RobotMoveToAction;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class CombineInstruction
implements PlcInstruction {
    private final Supplier<class_1937> worldSupplier;
    protected Argument from;
    protected Argument to;
    private final GroupedRobotAction group;

    public CombineInstruction(Supplier<class_1937> world, List<Argument> arguments) {
        this.worldSupplier = world;
        this.from = arguments.get(0);
        this.to = arguments.get(1);
        this.group = GroupedRobotAction.of(new RobotMoveToAction(this.from.pos()), new SoundAction(world, class_3417.field_20610), AtomicAction.of(this::takeFirst), new RobotMoveToAction(this.to.pos()), AtomicAction.of(this::complete));
    }

    public CombineInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, List.of(Argument.fromNbt(nbt.method_10562("from")), Argument.fromNbt(nbt.method_10562("to"))));
        this.group.readNbt(nbt.method_10562("action"));
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (!(plc.getActuator() instanceof CombineActuator)) {
            throw NeepASM.RuntimeException.notSupported("COMBINE");
        }
        plc.addRobotAction(this.group, this::finish);
    }

    @Override
    public void cancel(PLC plc) {
        plc.controlActuator(a -> a.dumpStored(plc));
        this.group.end(plc);
    }

    private void takeFirst(PLC plc) throws NeepASM.RuntimeException {
        ResourceAmount<ItemVariant> stored = this.takeItem(LazyBlockApiCache.itemSided(this.from, this.worldSupplier));
        if (stored == null) {
            throw new NeepASM.RuntimeException("COMBINE: no item found");
        }
        plc.getActuator().setStored(plc, stored);
        class_1937 class_19372 = this.worldSupplier.get();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ParticleSpawnS2C.sendNearby(serverWorld, this.from.pos(), new class_2392(class_2398.field_11218, ((ItemVariant)stored.resource()).toStack()), class_243.method_24953((class_2382)this.from.pos()), new class_243(0.0, 0.3, 0.0), new class_243(0.1, 0.1, 0.1), 4);
        }
    }

    private void complete(PLC plc) throws NeepASM.RuntimeException {
        PLCActuator actuator = plc.getActuator();
        ResourceAmount<ItemVariant> stored = actuator.getStored(plc);
        MutateInPlace mip = (MutateInPlace)MutateInPlace.ITEM.find(this.worldSupplier.get(), this.to.pos(), null);
        if (stored != null && mip != null && mip.get() != null) {
            Workpiece workpiece;
            class_1799 stack = (class_1799)mip.get();
            CombineStep step = CombineStep.get(((ItemVariant)stored.resource()).toStack((int)stored.amount()));
            Object object = ((ItemVariant)stored.resource()).getObject();
            if (object instanceof ItemImplantItem) {
                ItemImplantItem item = (ItemImplantItem)object;
                boolean installed = item.install(stack, s -> actuator.spawnItem(MeatlibStorageUtil.amountFromStack(s)));
                if (installed) {
                    actuator.setStored(plc, null);
                    mip.setResult(1, stack);
                    this.playCompleteSound(plc);
                } else {
                    actuator.dumpStored(plc);
                }
            }
            if ((workpiece = (Workpiece)NMComponents.WORKPIECE.maybeGet((Object)stack).orElse(null)) != null && PLCRecipes.isValidStep(PLCRecipes.MANUFACTURE, workpiece, step, stack.method_7909())) {
                workpiece.addStep(step);
                mip.setResult(1, stack);
                ItemManufactureRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(PLCRecipes.MANUFACTURE, mip).orElse(null);
                if (recipe != null) {
                    recipe.ejectOutputs(mip, (TransactionContext)null);
                    workpiece.clearSteps();
                }
                this.playCompleteSound(plc);
                actuator.setStored(plc, null);
                return;
            }
        }
        actuator.dumpStored(plc);
    }

    private void playCompleteSound(PLC plc) throws NeepASM.RuntimeException {
        class_1937 class_19372 = this.worldSupplier.get();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PLCActuator robot = plc.getActuator();
            serverWorld.method_47967(null, robot.getX(), robot.getY(), robot.getZ(), NMSounds.COMBINE_INSTRUCTION_APPLY, class_3419.field_15254, 1.0f, 1.0f, 1L);
        }
    }

    private ResourceAmount<ItemVariant> takeItem(LazyBlockApiCache<Storage<ItemVariant>, class_2350> target) {
        Storage<ItemVariant> storage = target.find();
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                ResourceAmount found = StorageUtil.findExtractableContent(storage, (TransactionContext)transaction);
                if (found != null) {
                    long extracted = storage.extract((Object)((ItemVariant)found.resource()), 1L, (TransactionContext)transaction);
                    if (extracted > 0L) {
                        ResourceAmount res = new ResourceAmount((Object)((ItemVariant)found.resource()), extracted);
                        transaction.commit();
                        ResourceAmount resourceAmount = res;
                        return resourceAmount;
                    }
                    transaction.abort();
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.COMBINE;
    }

    void finish(PLC plc) {
        plc.advanceCounter();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("from", (class_2520)this.from.toNbt());
        nbt.method_10566("to", (class_2520)this.to.toNbt());
        nbt.method_10566("action", (class_2520)this.group.writeNbt(new class_2487()));
        return nbt;
    }
}

