/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.compiler;

import com.neep.neepmeat.api.plc.program.PLCProgram;
import com.neep.neepmeat.api.storage.WorldSupplier;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmPLCCompiler;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.compiler.PLCCompilePipeline;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.thord.parser.ThordDictionary;
import com.neep.neepmeat.thord.parser.ThordParsedSource;
import com.neep.neepmeat.thord.parser.ThordParser;
import com.neep.neepmeat.thord.token.ThordLexer;
import java.util.Map;

public class ThordCompilePipeline
implements PLCCompilePipeline<ThordParsedSource> {
    private final ThordParser parser;
    private final NeepAsmPLCCompiler compiler;
    private final ThordDictionary dictionary = new ThordDictionary();

    public ThordCompilePipeline(WorldSupplier worldSupplier) {
        Map<String, InstructionProvider> map = Instructions.REGISTRY;
        ThordLexer lexer = new ThordLexer(this.dictionary, map.keySet());
        this.parser = new ThordParser(lexer, map);
        this.compiler = new NeepAsmPLCCompiler(worldSupplier);
    }

    @Override
    public ThordParsedSource parse(String source) throws NeepASM.ProgramBuildException {
        this.dictionary.reset();
        return this.parser.parse(source, this.dictionary);
    }

    @Override
    public PLCProgram compile(ThordParsedSource intermediate) throws NeepASM.ProgramBuildException {
        return this.compiler.compile(intermediate);
    }
}

