/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.block.entity;

import com.google.common.collect.Queues;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.interrupt.InterruptEmitter;
import com.neep.neepmeat.api.plc.interrupt.InterruptReceiver;
import com.neep.neepmeat.api.plc.program.PLCProgram;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.client.screen.plc.LanguageMode;
import com.neep.neepmeat.client.screen.plc.RecordMode;
import com.neep.neepmeat.machine.surgical_controller.SurgicalRobot;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.neepasm.program.Program;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.network.plc.PLCRobotEnterS2C;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.PLCState;
import com.neep.neepmeat.plc.editor.ProgramEditor;
import com.neep.neepmeat.plc.editor.ShellState;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.processor.PLCMemory;
import com.neep.neepmeat.plc.processor.VariableStack;
import com.neep.neepmeat.plc.robot.InterruptManager;
import com.neep.neepmeat.plc.robot.PLCActuator;
import com.neep.neepmeat.plc.screen.PLCScreenHandler;
import com.neep.neepmeat.thord.compiler.CheckedIntStack;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import java.util.Queue;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PLCBlockEntity
extends SyncableBlockEntity
implements InterruptReceiver,
ExtendedScreenHandlerFactory,
PLCActuator.Provider {
    @NotNull
    protected Supplier<PLCProgram> programSupplier;
    protected PlcInstruction currentInstruction;
    protected int counter;
    private boolean counterChanged;
    private boolean paused;
    protected final Queue<Pair<RobotAction, PLC.PLCConsumer>> robotActions = Queues.newArrayDeque();
    @Nullable
    protected Pair<RobotAction, PLC.PLCConsumer> currentAction;
    protected final SurgicalRobot robot = new SurgicalRobot(this);
    protected boolean overrideController;
    protected final ShellState shell = new ShellState(this);
    private final ProgramEditor editor = new ProgramEditor(this);
    @Nullable
    private PLC.Error error;
    private final PLCPropertyDelegate delegate = new PLCPropertyDelegate();
    private final int maxStackSize = 32;
    private final CheckedIntStack callStack = new CheckedIntStack(32, "return stack");
    private final VariableStack variableStack = new VariableStack(32);
    private final PLCMemory memory = new PLCMemory(this.variableStack);
    private final InterruptManager interrupts = new InterruptManager(() -> ((PLCBlockEntity)this).method_10997(), this, this::method_5431);
    @Nullable
    private PLCActuator selectedActuator = this.robot;
    @Nullable
    private class_2338 actuatorPos = null;
    private RecordMode mode = RecordMode.IMMEDIATE;
    private LanguageMode language = LanguageMode.THORD;
    private final CachingSender neepBusSender = new CachingSender(() -> ((PLCBlockEntity)this).method_10997(), this.method_11016());

    public PLCBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.programSupplier = () -> null;
    }

    @Override
    public void method_5431() {
        super.method_5431();
    }

    public void tick() {
        class_3218 serverWorld;
        class_1937 class_19372;
        this.editor.tick();
        this.interrupts.update();
        PLCProgram program = this.programSupplier.get();
        if (!this.paused && this.counter != -1 && program != null && this.error == null) {
            this.nextInstruction(this.currentInstruction, program, this.interrupts);
            if (this.currentInstruction != null && (this.currentInstruction.getOpcode() == Instructions.CALL || this.currentInstruction.getOpcode() == Instructions.RET) && this.counter != -1 && this.error == null) {
                this.nextInstruction(this.currentInstruction, program, this.interrupts);
            }
        }
        if (program != null || this.currentInstruction != null) {
            if (this.currentAction == null || ((RobotAction)this.currentAction.first()).finished(this)) {
                if (this.currentAction != null) {
                    try {
                        ((PLC.PLCConsumer)this.currentAction.second()).accept(this);
                    }
                    catch (NeepASM.RuntimeException e) {
                        this.raiseError(e);
                    }
                    ((RobotAction)this.currentAction.first()).end(this);
                }
                if (this.robotActions.peek() != null) {
                    this.currentAction = this.robotActions.poll();
                    try {
                        ((RobotAction)this.currentAction.first()).start(this);
                    }
                    catch (NeepASM.RuntimeException e) {
                        this.raiseError(e);
                    }
                    this.sync();
                } else if (this.currentAction != null) {
                    this.robot.stay();
                    this.currentAction = null;
                    this.sync();
                }
            } else {
                try {
                    ((RobotAction)this.currentAction.first()).tick(this);
                }
                catch (NeepASM.RuntimeException e) {
                    this.raiseError(e);
                }
            }
        }
        boolean prevOverride = this.overrideController;
        this.overrideController = this.currentAction == null || ((RobotAction)this.currentAction.first()).finished(this) ? false : ((RobotAction)this.currentAction.first()).blocksController();
        if (this.overrideController != prevOverride) {
            this.sync();
        }
        if ((class_19372 = this.field_11863) instanceof class_3218 && this.robot.shouldUpdatePosition((class_1937)(serverWorld = (class_3218)class_19372))) {
            this.robot.syncPosition(serverWorld);
        }
        this.robot.tick();
    }

    @Override
    public void addRobotAction(RobotAction action, PLC.PLCConsumer callback) {
        this.robotActions.add((Pair<RobotAction, PLC.PLCConsumer>)Pair.of((Object)action, (Object)callback));
    }

    @Override
    public PLCActuator getActuator() {
        if (this.actuatorPos != null && this.selectedActuator == null) {
            this.selectedActuator = this.findActuator(this.actuatorPos);
        }
        if (this.selectedActuator == null || this.selectedActuator.actuatorRemoved()) {
            this.selectedActuator = this.robot;
            this.actuatorPos = this.method_11016();
        }
        return this.selectedActuator;
    }

    public SurgicalRobot getSurgeryRobot() {
        return this.robot;
    }

    public void enter(class_1657 player) {
        if (this.robot.getController() == null) {
            this.robot.setController(player);
            if (!this.field_11863.method_8608()) {
                PLCRobotEnterS2C.send(player, this);
            }
            player.method_17355((class_3908)this);
        }
    }

    @Override
    public VariableStack dataStack() {
        this.method_5431();
        return this.variableStack;
    }

    @Override
    public DataStack returnStack() {
        this.method_5431();
        return this.callStack;
    }

    public VariableStack getVariableStack() {
        return this.variableStack;
    }

    @Override
    public PLCMemory getMemory() {
        return this.memory;
    }

    @Override
    public int counter() {
        return this.counter;
    }

    @Override
    public void setCounter(int counter) {
        if (counter == -1) {
            this.stop();
        } else {
            this.counter = counter;
            this.counterChanged = true;
        }
        this.method_5431();
    }

    @Override
    public void advanceCounter() {
        ++this.counter;
        this.counterChanged = true;
        this.method_5431();
    }

    private void say(class_2561 what) {
        PlayerLookup.around((class_3218)((class_3218)this.method_10997()), (class_2382)this.method_11016(), (double)20.0).forEach(p -> p.method_43496((class_2561)class_2561.method_30163((String)("[PLC at " + this.method_11016().method_10263() + " " + this.method_11016().method_10264() + " " + this.method_11016().method_10260() + "] ")).method_27661().method_10852(what)));
    }

    public void raiseError(NeepASM.RuntimeException e) {
        this.raiseError(new PLC.Error(e));
    }

    @Override
    public void raiseError(PLC.Error error) {
        this.say(error.what());
        this.error = error;
        this.paused = true;
        this.robotActions.clear();
        if (this.currentAction != null) {
            this.currentAction = null;
        }
        if (this.currentInstruction != null) {
            this.currentInstruction.cancel(this);
        }
        this.robot.stay();
        this.callStack.clear();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_11251, this.robot.getX(), this.robot.getY(), this.robot.getZ(), 20, 0.25, 0.25, 0.25, 0.1);
        }
    }

    public void resetError() {
        this.error = null;
    }

    @Nullable
    public PLC.Error getError() {
        return this.error;
    }

    @Override
    public void selectActuator(@Nullable class_2338 pos) throws NeepASM.RuntimeException {
        PLCActuator actuator = this.findActuator(pos);
        if (actuator == null) {
            throw new NeepASM.RuntimeException("Block at " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + " is not an actuator.");
        }
        this.selectedActuator = actuator;
        this.method_5431();
    }

    @Nullable
    private PLCActuator findActuator(@Nullable class_2338 pos) {
        if (pos == null) {
            return this.robot;
        }
        class_2586 class_25862 = this.field_11863.method_8321(pos);
        if (class_25862 instanceof PLCActuator.Provider) {
            PLCActuator.Provider actuator = (PLCActuator.Provider)class_25862;
            return actuator.getPlcActuator();
        }
        return null;
    }

    private void nextInstruction(@Nullable PlcInstruction current, @NotNull PLCProgram program, InterruptManager interrupts) {
        Instruction instruction = program.get(this.counter);
        if (this.counterChanged || instruction != current) {
            this.counterChanged = false;
            if (interrupts.hasQueued()) {
                Label entry = interrupts.poll();
                try {
                    this.callStack.push(this.counter);
                }
                catch (NeepASM.RuntimeException e) {
                    this.raiseError(e);
                }
                this.setCounter(entry.index());
                instruction = program.get(this.counter);
            }
            this.execute(instruction);
            this.sync();
        }
    }

    public void execute(Instruction instruction) {
        if (instruction instanceof PlcInstruction) {
            PlcInstruction plcInstruction = (PlcInstruction)instruction;
            if (plcInstruction.canStart(this)) {
                this.robotActions.clear();
                if (this.currentAction != null) {
                    this.currentAction = null;
                }
                this.currentInstruction = plcInstruction;
                try {
                    instruction.start(this);
                }
                catch (NeepASM.RuntimeException e) {
                    this.raiseError(e);
                }
            }
        } else {
            try {
                instruction.start(this);
            }
            catch (NeepASM.RuntimeException e) {
                this.raiseError(e);
            }
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.robot.writeNbt(nbt);
        nbt.method_10556("override_controller", this.overrideController);
        nbt.method_10569("counter", this.counter);
        nbt.method_10556("paused", this.paused);
        nbt.method_10575("mode", (short)this.mode.ordinal());
        nbt.method_10575("language", (short)this.language.ordinal());
        nbt.method_10566("editor", (class_2520)this.editor.writeNbt(new class_2487()));
        nbt.method_10556("has_program", this.programSupplier.get() != null);
        nbt.method_10539("call_stack", this.callStack.toArray());
        nbt.method_10566("variable_stack", (class_2520)this.variableStack.writeNbt(new class_2487()));
        nbt.method_10566("interrupts", (class_2520)this.interrupts.writeNbt(new class_2487()));
        nbt.method_10566("memory", (class_2520)this.memory.writeNbt(new class_2487()));
        if (this.selectedActuator != this.robot && this.selectedActuator != null) {
            nbt.method_10566("actuator", (class_2520)class_2512.method_10692((class_2338)this.selectedActuator.getBasePos()));
        } else if (this.selectedActuator == null) {
            nbt.method_10566("actuator", (class_2520)class_2512.method_10692((class_2338)this.actuatorPos));
        }
    }

    @Override
    public void toClientTag(class_2487 nbt) {
        this.robot.writeNbt(nbt);
        nbt.method_10556("override_controller", this.overrideController);
        nbt.method_10569("counter", this.counter);
        nbt.method_10556("paused", this.paused);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.robot.readNbt(nbt);
        this.overrideController = nbt.method_10577("override_controller");
        this.counter = nbt.method_10550("counter");
        this.paused = nbt.method_10577("paused");
        this.mode = RecordMode.values()[nbt.method_10568("mode")];
        this.language = LanguageMode.values()[nbt.method_10568("language")];
        this.editor.readNbt(nbt.method_10562("editor"));
        this.callStack.read(nbt.method_10561("call_stack"));
        this.variableStack.readNbt(nbt.method_10562("variable_stack"));
        this.interrupts.readNbt(nbt.method_10562("interrupts"));
        this.memory.readNbt(nbt.method_10562("memory"));
        if (nbt.method_10577("has_program")) {
            this.programSupplier = this.editor::getProgram;
        }
        if (nbt.method_10545("actuator")) {
            this.actuatorPos = class_2512.method_10691((class_2487)nbt.method_10562("actuator"));
            this.selectedActuator = null;
        } else {
            this.actuatorPos = null;
            this.selectedActuator = this.robot;
        }
    }

    public void method_38240(class_1799 stack) {
        class_2487 createdNbt = this.method_38244();
        createdNbt.method_10551("robot");
        class_1747.method_38073((class_1799)stack, (class_2591)this.method_11017(), (class_2487)createdNbt);
    }

    public boolean notExecuting() {
        return this.currentAction == null || ((RobotAction)this.currentAction.first()).finished(this);
    }

    public boolean overrideController() {
        return this.overrideController;
    }

    public void exit() {
        this.robot.setController(null);
    }

    public PLCState getState() {
        return this.shell;
    }

    public boolean actionBlocksController() {
        return this.currentAction != null && ((RobotAction)this.currentAction.first()).blocksController();
    }

    public void setMode(RecordMode value) {
        this.mode = value;
        this.method_5431();
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new PLCScreenHandler(syncId, player, this, this.delegate, this.editor.getSource());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        buf.method_10814(this.editor.getSource());
        buf.writeInt(this.mode.ordinal());
    }

    private void clear() {
        this.resetError();
        this.variableStack.clear();
        this.memory.clear();
        this.interrupts.setEnabled(true);
        this.interrupts.clear();
        this.currentInstruction = null;
    }

    public void runProgram(@Nullable PLCProgram program) {
        if (this.programSupplier.get() != program) {
            this.clear();
            this.programSupplier = () -> program;
        }
        this.paused = false;
        if (this.counter == -1) {
            this.counter = 0;
        }
    }

    public void hardStop() {
        if (this.currentInstruction != null) {
            this.currentInstruction.cancel(this);
            this.currentInstruction = null;
        }
        if (this.currentAction != null) {
            this.currentAction = null;
            this.robotActions.clear();
        }
        this.stop();
    }

    public void stop() {
        this.programSupplier = () -> null;
        this.counter = -1;
        this.paused = true;
        this.callStack.clear();
        this.interrupts.setEnabled(true);
        this.interrupts.clear();
    }

    public void pause() {
        this.paused = true;
    }

    public void step() {
        if (this.programSupplier.get() == null) {
            this.editor.compile(p -> {
                this.programSupplier = () -> p;
            });
            return;
        }
        if (this.programSupplier.get() != null) {
            if (this.counter == -1) {
                this.clear();
                this.counter = 0;
            }
            this.paused = true;
            this.nextInstruction(this.currentInstruction, this.programSupplier.get(), this.interrupts);
        }
    }

    public ProgramEditor getProgramEditor() {
        return this.editor;
    }

    @Override
    public PLCActuator getPlcActuator() {
        return this.robot;
    }

    public void updateVariableStack(class_2487 nbt) {
        this.variableStack.readNbt(nbt);
    }

    @Override
    public InterruptManager getInterrupts() {
        return this.interrupts;
    }

    @Override
    public void interrupt(class_2338 pos, InterruptEmitter emitter) {
        if (this.programSupplier.get() != null) {
            this.interrupts.interrupt(pos, emitter);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.interrupts.setEnabled(enabled);
    }

    public void setLanguage(LanguageMode languageMode) {
        this.language = languageMode;
        this.editor.updatePipeline();
        this.method_5431();
    }

    public LanguageMode getLanguage() {
        return this.language;
    }

    public void resetRobot() {
        this.robot.returnToBase();
    }

    public void updateMemory(ByteBuf bb) {
        this.memory.read(bb);
    }

    private int getDebugLine() {
        Program program = this.programSupplier.get();
        if (program != null) {
            return program.getDebugLine(this.counter);
        }
        return -1;
    }

    public CachingSender getSender() {
        return this.neepBusSender;
    }

    public class PLCPropertyDelegate
    implements class_3913 {
        public static final int SIZE = Names.values().length;

        public int method_17390(int index) {
            return switch (Names.values()[index]) {
                default -> throw new IncompatibleClassChangeError();
                case Names.PROGRAM_COUNTER -> PLCBlockEntity.this.counter;
                case Names.HAS_PROGRAM -> {
                    if (PLCBlockEntity.this.programSupplier.get() != null || PLCBlockEntity.this.currentInstruction != null && PLCBlockEntity.this.currentInstruction != Instruction.EMPTY) {
                        yield 1;
                    }
                    yield 0;
                }
                case Names.EDIT_MODE -> PLCBlockEntity.this.mode.ordinal();
                case Names.LANGUAGE -> PLCBlockEntity.this.language.ordinal();
                case Names.RUNNING -> {
                    if (PLCBlockEntity.this.programSupplier.get() != null && !PLCBlockEntity.this.paused) {
                        yield 1;
                    }
                    yield 0;
                }
                case Names.ARGUMENT -> PLCBlockEntity.this.shell.getArgumentCount();
                case Names.MAX_ARGUMENTS -> PLCBlockEntity.this.shell.getMaxArguments();
                case Names.DEBUG_LINE -> PLCBlockEntity.this.getDebugLine();
                case Names.SELECTED_INSTRUCTION -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (Names.values()[index]) {
                case PROGRAM_COUNTER: {
                    PLCBlockEntity.this.counter = value;
                    break;
                }
                case EDIT_MODE: {
                    PLCBlockEntity.this.setMode(RecordMode.values()[class_3532.method_15340((int)value, (int)0, (int)RecordMode.values().length)]);
                    break;
                }
            }
        }

        public int method_17389() {
            return SIZE;
        }

        public static enum Names {
            PROGRAM_COUNTER,
            HAS_PROGRAM,
            EDIT_MODE,
            LANGUAGE,
            RUNNING,
            ARGUMENT,
            MAX_ARGUMENTS,
            SELECTED_INSTRUCTION,
            DEBUG_LINE;

        }
    }
}

