/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.plc.interrupt.InterruptEmitter;
import com.neep.neepmeat.api.plc.interrupt.InterruptReceiver;
import com.neep.neepmeat.api.plc.memory.MemoryProvider;
import com.neep.neepmeat.item.filter.Filter;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.item.filter.ItemFilter;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.memory.ItemRequestMemoryEntry;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ItemRequestReceiverBlockEntity
extends SyncableBlockEntity
implements InterruptEmitter,
RoutablePipe,
MemoryProvider {
    private final Set<InterruptReceiver> receivers = new HashSet<InterruptReceiver>();
    private final List<ResourceAmount<ItemVariant>> requests = new ObjectArrayList();
    private final LockedFilterList filterList = new LockedFilterList(1, this::method_5431);

    public ItemRequestReceiverBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addListener(InterruptReceiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public RoutablePipe.Result request(Predicate<ItemVariant> predicate, long amount, NodePos fromPos, RoutingNetwork.RequestContext context, TransactionContext transaction) {
        for (InterruptReceiver receiver : this.receivers) {
            receiver.interrupt(this.field_11867, this);
        }
        for (ItemVariant item : this.filterList.getItemFilter().getItems()) {
            if (!predicate.test(item)) continue;
            this.requests.add((ResourceAmount<ItemVariant>)new ResourceAmount((Object)item, amount));
        }
        this.method_5431();
        return RoutablePipe.Result.FAIL;
    }

    @Override
    public Stream<StorageView<ItemVariant>> getAvailable(TransactionContext transaction) {
        return this.filterList.getItemFilter().getItems().stream().filter(v -> !v.isBlank()).map(SimpleView::new);
    }

    @Override
    public class_2338 getRoutablePipePos() {
        return this.field_11867;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.requests.clear();
        class_2499 list = nbt.method_10554("list", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            this.requests.add(PlcInstruction.readItem(compound));
        }
        this.filterList.readNbt(nbt.method_10562("filter"));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 list = new class_2499();
        this.requests.forEach(r -> list.add((Object)PlcInstruction.writeItem((ResourceAmount<ItemVariant>)r)));
        nbt.method_10566("list", (class_2520)list);
        nbt.method_10566("filter", (class_2520)this.filterList.writeNbt(new class_2487()));
    }

    @Override
    @Nullable
    public MemoryEntry pop() {
        if (!this.requests.isEmpty()) {
            ResourceAmount<ItemVariant> request = this.requests.get(this.requests.size() - 1);
            this.requests.remove(this.requests.size() - 1);
            return new ItemRequestMemoryEntry(((ItemVariant)request.resource()).getItem(), (int)request.amount());
        }
        return null;
    }

    @Override
    public void push(MemoryEntry entry) {
    }

    public FilterList getFilters() {
        return this.filterList;
    }

    private static class LockedFilterList
    extends FilterList {
        public LockedFilterList(int maxEntries, Runnable markDirty) {
            super(maxEntries, markDirty);
            this.entries.add(new FilterList.Entry(new ItemFilter()));
        }

        @Override
        public void add(Filter filter) {
        }

        @Override
        public void remove(int i) {
        }

        public ItemFilter getItemFilter() {
            return (ItemFilter)((FilterList.Entry)this.entries.get(0)).getFilter();
        }
    }

    private record SimpleView(ItemVariant variant) implements StorageView<ItemVariant>
    {
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean isResourceBlank() {
            return false;
        }

        public ItemVariant getResource() {
            return this.variant;
        }

        public long getAmount() {
            return 1L;
        }

        public long getCapacity() {
            return 1L;
        }
    }
}

