/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.particle;

import com.neep.neepmeat.particle.SwirlingParticleEffect;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_761;

public class SwirlingParticle
extends class_4003 {
    private final class_2338 blockPos;
    private final float sampleU;
    private final float sampleV;
    private final double radius;
    private final double originX;
    private final double originY;
    private final double originZ;
    private final double speed;
    private double angle;

    public SwirlingParticle(class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double radius, double angle, double speed, class_2680 state) {
        this(world, x, y, z, velocityX, velocityY, velocityZ, radius, angle, speed, state, class_2338.method_49637((double)x, (double)y, (double)z));
    }

    public SwirlingParticle(class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double radius, double angle, double speed, class_2680 state, class_2338 blockPos) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.radius = radius;
        this.speed = speed;
        this.angle = this.field_3840.method_43058() * 2.0 * Math.PI;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.field_3874 = SwirlingParticle.getRectX(this.originX, this.angle, radius);
        this.field_3871 = SwirlingParticle.getRectZ(this.originZ, this.angle, radius);
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.blockPos = blockPos;
        this.method_18141(class_310.method_1551().method_1541().method_3351().method_3339(state));
        this.field_3844 = 1.0f;
        this.field_3861 = 0.6f;
        this.field_3842 = 0.6f;
        this.field_3859 = 0.6f;
        if (!state.method_27852(class_2246.field_10219)) {
            int i = class_310.method_1551().method_1505().method_1697(state, (class_1920)world, blockPos, 0);
            this.field_3861 *= (float)(i >> 16 & 0xFF) / 255.0f;
            this.field_3842 *= (float)(i >> 8 & 0xFF) / 255.0f;
            this.field_3859 *= (float)(i & 0xFF) / 255.0f;
        }
        this.field_17867 /= 2.0f;
        this.sampleU = this.field_3840.method_43057() * 3.0f;
        this.sampleV = this.field_3840.method_43057() * 3.0f;
    }

    public static double getRectX(double x, double theta, double r) {
        return x + Math.cos(theta) * r;
    }

    public static double getRectZ(double z, double theta, double r) {
        return z + Math.sin(theta) * r;
    }

    public void method_3070() {
        this.angle += this.speed;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        this.field_3874 = SwirlingParticle.getRectX(this.originX, this.angle, this.radius);
        this.field_3871 = SwirlingParticle.getRectZ(this.originZ, this.angle, this.radius);
        if (this.field_3845 && this.field_3854 == this.field_3838) {
            this.field_3852 *= 1.1;
            this.field_3850 *= 1.1;
        }
        this.field_3852 *= (double)this.field_28786;
        this.field_3869 *= (double)this.field_28786;
        this.field_3850 *= (double)this.field_28786;
        if (this.field_3845) {
            this.field_3852 *= (double)0.7f;
            this.field_3850 *= (double)0.7f;
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17827;
    }

    public int method_3068(float tint) {
        int i = super.method_3068(tint);
        if (i == 0 && this.field_3851.method_22340(this.blockPos)) {
            return class_761.method_23794((class_1920)this.field_3851, (class_2338)this.blockPos);
        }
        return i;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<SwirlingParticleEffect> {
        public class_703 createParticle(SwirlingParticleEffect effect, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            class_2680 blockState = effect.getBlockState();
            if (blockState.method_26215() || blockState.method_27852(class_2246.field_10008)) {
                return null;
            }
            Random rand = new Random(0L);
            return new SwirlingParticle(clientWorld, d, e, f, g, h, i, effect.radius, 0.0, effect.speed, blockState);
        }
    }
}

