/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler;

import com.google.common.collect.Lists;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.ParsedInstructionList;
import com.neep.neepmeat.neepasm.compiler.alias.ParsedAlias;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedMacro;
import com.neep.neepmeat.neepasm.program.Label;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ParsedSource
implements InstructionAcceptor,
LabelLookup,
ParsedInstructionList {
    private final List<ObjectIntPair<ParsedInstruction>> instructions = Lists.newArrayList();
    private final List<Label> labels = Lists.newArrayList();
    private final List<ParsedFunction> functions = Lists.newArrayList();
    private final List<ParsedAlias> aliases = Lists.newArrayList();
    private final List<ParsedMacro> macros = Lists.newArrayList();

    @Override
    public void instruction(ParsedInstruction preInstruction, int line) {
        this.instructions.add((ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)preInstruction, (int)line));
    }

    @Override
    public void instruction(int index, ParsedInstruction preInstruction, int line) {
        this.instructions.set(index, (ObjectIntPair<ParsedInstruction>)ObjectIntPair.of((Object)preInstruction, (int)line));
    }

    @Override
    public void label(Label label) {
        this.labels.add(label);
    }

    @Override
    public void function(ParsedFunction function) {
        this.functions.add(function);
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    public void alias(ParsedAlias alias) {
        this.aliases.add(alias);
    }

    public void macro(ParsedMacro macro) {
        this.macros.add(macro);
    }

    @Override
    public Iterable<ObjectIntPair<ParsedInstruction>> instructions() {
        return this.instructions;
    }

    public Iterable<ParsedFunction> functions() {
        return this.functions;
    }

    @Override
    @Nullable
    public Label findLabel(String label) {
        return this.labels.stream().filter(l -> l.name().equals(label)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Label findLabel(String label, int origin, Label.Seek seek) {
        return switch (seek) {
            default -> throw new IncompatibleClassChangeError();
            case Label.Seek.FORWARDS -> LabelLookup.findForwards(this.labels, label, origin);
            case Label.Seek.BACKWARDS -> LabelLookup.findBackwards(this.labels, label, origin);
            case Label.Seek.ABSOLUTE -> this.findLabel(label);
        };
    }

    @Nullable
    public ParsedFunction findFunction(String name) {
        return this.functions.stream().filter(m -> m.name().equals(name)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public ParsedMacro findMacro(String name) {
        return this.macros.stream().filter(m -> m.name().equals(name)).findFirst().orElse(null);
    }

    @Nullable
    public ParsedAlias findAlias(String name) {
        return this.aliases.stream().filter(a -> a.name().equals(name)).findFirst().orElse(null);
    }

    public static String mangleLabel(String label, @Nullable String scope) {
        if (scope != null) {
            return scope + "#" + label;
        }
        return label;
    }
}

