/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.well_head;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.neep.neepmeat.NeepMeat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2818;

public class BlockEntityFinder<T extends class_2586> {
    private final class_1937 world;
    private final Set<class_1923> positions;
    private final Set<T> result = Sets.newHashSet();
    private final class_2591<T> type;
    private Predicate<class_2586> predicate = b -> true;
    private final int updateInterval;
    private long lastUpdate = 0L;

    public BlockEntityFinder(class_1937 world, class_2591<T> type, int updateInterval) {
        this.world = world;
        this.type = type;
        this.updateInterval = updateInterval;
        this.positions = Sets.newHashSet();
    }

    public static Collection<class_1923> chunkRange(class_2338 pos) {
        class_1923 origin = new class_1923(pos);
        ArrayList list = Lists.newArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                list.add(new class_1923(i + origin.field_9181, k + origin.field_9180));
            }
        }
        return list;
    }

    public BlockEntityFinder<T> addAll(Collection<class_1923> list) {
        this.positions.addAll(list);
        return this;
    }

    public BlockEntityFinder<T> predicate(Predicate<class_2586> predicate) {
        this.predicate = predicate;
        return this;
    }

    public void tick() {
        this.result.removeIf(class_2586::method_11015);
        if (this.world.method_8510() < this.lastUpdate + (long)this.updateInterval) {
            return;
        }
        this.lastUpdate = this.world.method_8510();
        this.result.clear();
        for (class_1923 chunkPos : this.positions) {
            class_2818 chunk = this.world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            try {
                chunk.method_12214().values().stream().filter(be -> be.method_11017().equals(this.type)).filter(this.predicate).forEach(be -> this.result.add(be));
            }
            catch (ClassCastException e) {
                NeepMeat.LOGGER.error("Block entity in chunk {} {}: class does not match type: {}", (Object)chunkPos.field_9181, (Object)chunkPos.field_9180, (Object)e.getMessage());
            }
        }
    }

    public boolean notDirty() {
        return this.world.method_8510() == this.lastUpdate;
    }

    public Set<T> result() {
        return this.result;
    }
}

