/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.trough;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.machine.motor.MotorEntity;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class TroughBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock {
    public static final FluidVariant RESOURCE = FluidVariant.of((class_3611)NMFluids.STILL_FEED);
    private final TroughStorage storage = new TroughStorage(162000L, this::sync);
    private int age = 0;
    private int waitTicks = 100;

    public TroughBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TroughBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.FEEDING_TROUGH, pos, state);
    }

    public WritableSingleFluidStorage getStorage(@Nullable class_2350 ignored) {
        return this.storage;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.toNbt(nbt);
        nbt.method_10569("wait_ticks", this.waitTicks);
        nbt.method_10569("age", this.age);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.waitTicks = nbt.method_10550("wait_ticks");
        this.age = nbt.method_10550("age");
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        class_1937 class_19372;
        ++this.age;
        if (this.age % this.waitTicks == 0) {
            this.feedAnimals();
        }
        if (motor.getMechPUPower() > 0.0 && this.field_11863.method_8510() % 10L == 0L && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)NMParticles.MEAT_BIT, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.5, 0.5, 0.5, 0.01);
        }
        return true;
    }

    @Override
    public void setInputPower(float power) {
        this.waitTicks = (int)class_3532.method_15363((float)((1.0f - power) * 60.0f * 20.0f), (float)100.0f, (float)1200.0f);
    }

    public void feedAnimals() {
        if (this.storage.isResourceBlank()) {
            return;
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_17741, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.6, (double)this.field_11867.method_10260() + 0.5, 4, 0.25, 0.25, 0.25, 0.1);
        }
        try (Transaction transaction = Transaction.openOuter();){
            class_238 box = class_238.method_19316((class_3341)new class_3341(this.field_11867).method_35410(5));
            Map<Boolean, List<class_1429>> entities = this.field_11863.method_18023(class_5575.method_31795(class_1429.class), box, e -> true).stream().collect(Collectors.partitioningBy(class_1296::method_6109));
            List<class_1429> adults = entities.get(false);
            List<class_1429> babies = entities.get(true);
            Collections.shuffle(adults);
            Collections.shuffle(babies);
            try (Transaction sub1 = transaction.openNested();){
                if (!babies.isEmpty() && this.extractFeed((Long)NeepMeat.CONFIG.feedingTrough.useAmount.getRealValue() / 2L, (TransactionContext)sub1)) {
                    babies.get(0).method_5614(60);
                    sub1.commit();
                } else {
                    sub1.abort();
                }
            }
            try (Transaction inner = transaction.openNested();){
                if (adults.size() >= 2 && this.extractFeed((Long)NeepMeat.CONFIG.feedingTrough.useAmount.getRealValue(), (TransactionContext)inner)) {
                    for (int i = 0; i < Math.min(2, adults.size()); ++i) {
                        class_1429 mob = adults.get(i);
                        mob.method_5614(0);
                        mob.method_6480(null);
                    }
                    inner.commit();
                } else {
                    inner.abort();
                }
            }
            transaction.commit();
        }
    }

    private boolean extractFeed(long amount, TransactionContext transaction) {
        return this.storage.extractDirect(RESOURCE, amount, transaction) == amount;
    }

    public boolean handleInteract(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(NMTags.GRAINS) || stack.method_31574(NMBlocks.FLESH_POTATO.method_8389())) {
            try (Transaction transaction = Transaction.openOuter();){
                WritableSingleFluidStorage storage = this.getStorage(null);
                long perItem = (Long)NeepMeat.CONFIG.feedingTrough.feedPerItem.getRealValue();
                long inserted = storage.insert(RESOURCE, perItem, (TransactionContext)transaction);
                if (inserted >= perItem) {
                    stack.method_7934(1);
                    player.method_6122(hand, stack);
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
                transaction.abort();
            }
        } else {
            return WritableSingleFluidStorage.handleInteract((Storage<FluidVariant>)this.getStorage(null), world, player, hand);
        }
        return false;
    }

    private static class TroughStorage
    extends WritableSingleFluidStorage {
        public TroughStorage(long capacity, Runnable finalCallback) {
            super(capacity, finalCallback);
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long extractDirect(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            return super.extract((TransferVariant)extractedVariant, maxAmount, transaction);
        }
    }
}

