/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.synthesiser;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.neep.neepmeat.NeepMeat;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1826;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MobSynthesisRegistry
implements SimpleSynchronousResourceReloadListener {
    private static final MobSynthesisRegistry INSTANCE = new MobSynthesisRegistry();
    private final Map<class_1299<?>, Entry> entries = Maps.newHashMap();
    private final Set<class_1299<?>> denyTypes = Sets.newHashSet();

    @Nullable
    public static Entry get(class_1297 entity) {
        return MobSynthesisRegistry.get(entity.method_5864());
    }

    @Nullable
    public static Entry get(class_1299<?> type) {
        return MobSynthesisRegistry.getInstance().getEntry(type);
    }

    @Nullable
    public Entry getEntry(class_1299<?> type) {
        if (this.denyTypes.contains(type)) {
            return null;
        }
        return this.entries.get(type);
    }

    public static long meatFromSize(class_1297 entity) {
        return (long)Math.floor(entity.method_17682() * entity.method_17681() * entity.method_17681() * 81000.0f);
    }

    public static long meatFromSize(class_1299<?> entity) {
        return (long)Math.floor(entity.method_17686() * entity.method_17685() * entity.method_17685() * 81000.0f);
    }

    public static MobSynthesisRegistry getInstance() {
        return INSTANCE;
    }

    public void method_14491(class_3300 manager) {
        this.entries.clear();
        this.denyTypes.clear();
        this.initDefaults();
        for (class_2960 id : manager.method_14488("cloning", path -> path.method_12832().endsWith(".json")).keySet()) {
            if (!manager.method_14486(id).isPresent()) continue;
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    JsonObject rootObject = (JsonObject)rootElement;
                    JsonArray allowJson = class_3518.method_15261((JsonObject)rootObject, (String)"extra");
                    allowJson.forEach(jsonElement -> {
                        if (jsonElement instanceof JsonObject) {
                            JsonObject jsonObject = (JsonObject)jsonElement;
                            if (jsonObject.size() != 1) {
                                throw new JsonSyntaxException("Expected entity ID string or object containing entity ID and meat amount");
                            }
                            jsonObject.entrySet().forEach(entry -> {
                                String entityIdStr = (String)entry.getKey();
                                class_2960 entityId = new class_2960(entityIdStr);
                                int meat = ((JsonElement)entry.getValue()).getAsInt();
                                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
                                this.entries.put(entityType, new Entry(entityType, meat, 60));
                            });
                        } else {
                            String entityIdStr = jsonElement.getAsString();
                            class_2960 entityId = new class_2960(entityIdStr);
                            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
                            long meat = MobSynthesisRegistry.meatFromSize(entityType);
                            this.entries.put(entityType, new Entry(entityType, meat, 60));
                        }
                    });
                    JsonArray denyJson = class_3518.method_15261((JsonObject)rootObject, (String)"deny");
                    denyJson.forEach(jsonElement -> {
                        class_3518.method_15287((JsonElement)jsonElement, (String)jsonElement.toString());
                        String entityIdStr = jsonElement.getAsString();
                        class_2960 entityId = new class_2960(entityIdStr);
                        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
                        this.denyTypes.add(entityType);
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NeepMeat.LOGGER.error("Error occurred while loading cloning json " + id.toString(), (Throwable)e);
            }
        }
    }

    private void initDefaults() {
        class_1826.method_8017().forEach(eggItem -> {
            class_1299 type = eggItem.method_8015(null);
            if (type == null) {
                return;
            }
            this.entries.put(type, new Entry(type, MobSynthesisRegistry.meatFromSize(type), 60));
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("neepmeat", "cloning");
    }

    public record Entry(class_1299<?> type, long meat, int time) {
    }
}

