/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.surgical_controller;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.client.plc.PLCHudRenderer;
import com.neep.neepmeat.machine.surgical_controller.SurgicalRobot;
import com.neep.neepmeat.plc.block.entity.PLCBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.task.RunnablePlan;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PLCVisual
extends AbstractBlockEntityVisual<PLCBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance robotModel;
    private final class_4587 matrixStack = new class_4587();
    private final int animOffset;

    public PLCVisual(VisualizationContext ctx, PLCBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.matrixStack.method_46416((float)this.getVisualPosition().method_10263(), (float)this.getVisualPosition().method_10264(), (float)this.getVisualPosition().method_10260());
        this.robotModel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.cutout(NMExtraModels.P_PLC_ROBOT)).createInstance();
        this.animOffset = (int)(Math.random() * 360.0);
    }

    public void _delete() {
        this.robotModel.delete();
    }

    public void beginFrame(DynamicVisual.Context context) {
        SurgicalRobot robot = ((PLCBlockEntity)this.blockEntity).getSurgeryRobot();
        robot.prevX = robot.clientX;
        robot.prevY = robot.clientY;
        robot.prevZ = robot.clientZ;
        robot.clientX = class_3532.method_16436((double)0.1, (double)robot.clientX, (double)robot.getX());
        robot.clientY = class_3532.method_16436((double)0.1, (double)robot.clientY, (double)robot.getY());
        robot.clientZ = class_3532.method_16436((double)0.1, (double)robot.clientZ, (double)robot.getZ());
        robot.clientYaw = class_3532.method_17821((float)0.1f, (float)robot.clientYaw, (float)robot.getYaw());
        double vx = robot.clientX - robot.prevX;
        double vy = robot.clientY - robot.prevY;
        double vz = robot.clientZ - robot.prevZ;
        double speed = (float)Math.sqrt(vx * vx + vz * vz);
        PLCHudRenderer plcHudRenderer = PLCHudRenderer.getInstance();
        if (plcHudRenderer != null && plcHudRenderer.getBlockEntity() == this.blockEntity) {
            this.robotModel.setIdentityTransform().scale(0.0f, 0.0f, 0.0f);
        } else {
            this.matrixStack.method_22903();
            this.matrixStack.method_22904(robot.clientX - (double)((PLCBlockEntity)this.blockEntity).method_11016().method_10263() - 0.5, robot.clientY - (double)((PLCBlockEntity)this.blockEntity).method_11016().method_10264() - 0.5, robot.clientZ - (double)((PLCBlockEntity)this.blockEntity).method_11016().method_10260() - 0.5);
            float tickDelta = context.partialTick();
            int time = (int)(((PLCBlockEntity)this.blockEntity).method_10997().method_8510() % 360L + (long)this.animOffset);
            double sinTime = Math.sin(Math.toRadians(time * 7)) * Math.cos(Math.toRadians(tickDelta) * 7.0) + Math.cos(Math.toRadians(time * 7)) * Math.sin(Math.toRadians(tickDelta) * 7.0);
            boolean floating = robot.getState();
            this.matrixStack.method_22904(0.0, 0.5 + (!floating ? 0.1 * sinTime : 0.0), 0.0);
            this.matrixStack.method_22904(0.5, 0.5, 0.5);
            this.matrixStack.method_22907(class_7833.field_40715.rotationDegrees(robot.clientYaw + 180.0f));
            this.matrixStack.method_22907(class_7833.field_40713.rotationDegrees((float)(100.0 * speed)));
            this.matrixStack.method_22904(-0.5, -0.5, -0.5);
            this.robotModel.setTransform(this.matrixStack);
            this.matrixStack.method_22909();
        }
        this.robotModel.setChanged();
    }

    public void updateLight(float v) {
        SurgicalRobot robot = ((PLCBlockEntity)this.blockEntity).getSurgeryRobot();
        this.relight(class_2338.method_49637((double)robot.clientX, (double)robot.clientY, (double)robot.clientZ), new FlatLit[]{this.robotModel});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public Plan<DynamicVisual.Context> planFrame() {
        return RunnablePlan.of(this::planFrame);
    }
}

