/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.reactor.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.machine.reactor.IntrusionReactor;
import com.neep.neepmeat.machine.reactor.ReactionCoreParameters;
import com.neep.neepmeat.machine.reactor.ReceiverOrganismComponent;
import com.neep.neepmeat.machine.reactor.ReceiverOrganismComponentProvider;
import com.neep.neepmeat.machine.reactor.ReceiverOrganismStructure;
import com.neep.neepmeat.machine.reactor.block.entity.CoreSensorBlockEntity;
import com.neep.neepmeat.util.IterateRandomly;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ReactionCoreBlockEntity
extends SyncableBlockEntity {
    private final ReactionCoreParameters parameters = new ReactionCoreParameters();
    private final class_5819 random = class_5819.method_43047();
    private int age = 0;
    private final Object2IntMap<ReceiverOrganismStructure> structures = new Object2IntOpenHashMap();
    private class_2338 lastOrigin;
    public double lerpIncidentZoneRadius;
    public double clientIncidentZoneRadius;
    private final Object2FloatMap<ReceiverOrganismStructure.Property> properties = new Object2FloatArrayMap();
    private final Set<ReceiverOrganismComponent> components = new HashSet<ReceiverOrganismComponent>();
    @Nullable
    private CoreSensorBlockEntity sensor;
    private int disruption;
    private float maxOrgIncrease;

    public ReactionCoreBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.lastOrigin = pos;
    }

    public void serverTick() {
        ++this.age;
        if (this.age % 80 == 0) {
            this.updateStructure(this.method_11016());
        }
        int dt = 5;
        if (this.field_11863.method_8510() % (long)dt == 0L) {
            this.parameters.tick(this.disruption, this.properties.getOrDefault((Object)ReceiverOrganismStructure.Property.ORGANISATION, 0.0f), this.maxOrgIncrease, 5);
        }
        this.disruption = 0;
        this.maxOrgIncrease = 0.0f;
        if (this.field_11863.method_8510() % 10L == 0L) {
            double stored = this.parameters.getStoredExudate();
            float factor = 1.0f;
            int toPlace = (int)Math.floor(stored * (double)factor);
            int placed = this.placeExudate(toPlace);
            double toExtract = (float)placed / factor;
            this.parameters.extractStored(toExtract);
            this.sync();
        }
        this.components.removeIf(ReceiverOrganismComponent::isComponentRemoved);
        this.parameters.tickIncidentZone();
        if (this.field_11863.method_8510() % (long)dt == 0L && this.sensor != null) {
            this.parameters.emitSensorData(this.sensor);
        }
    }

    private void updateStructure(class_2338 origin) {
        ObjectArrayList structures = new ObjectArrayList();
        this.findStructures(this.field_11863, origin, (List<ReceiverOrganismStructure>)structures, this.components);
        EnumMap present = new EnumMap(ReceiverOrganismStructure.Property.class);
        for (ReceiverOrganismStructure structure : structures) {
            structure.getProperties().forEach((property, value) -> {
                if (value.function().average()) {
                    present.compute((ReceiverOrganismStructure.Property)property, (p, v) -> v == null ? 1 : v + 1);
                }
            });
        }
        this.properties.clear();
        for (ReceiverOrganismStructure structure : structures) {
            structure.getProperties().forEach((property, entry) -> {
                int numberPresent = present.getOrDefault(property, 1);
                this.properties.compute(property, (p, prev) -> {
                    if (prev == null) {
                        prev = Float.valueOf(p.defaultValue());
                    }
                    return Float.valueOf(entry.apply(prev.floatValue(), numberPresent));
                });
            });
        }
        for (ReceiverOrganismComponent component : this.components) {
            CoreSensorBlockEntity sensor1;
            if (!(component instanceof CoreSensorBlockEntity)) continue;
            this.sensor = sensor1 = (CoreSensorBlockEntity)component;
        }
    }

    private void findStructures(class_1937 world, class_2338 origin, List<ReceiverOrganismStructure> structures, Set<ReceiverOrganismComponent> components) {
        LongOpenHashSet visited = new LongOpenHashSet();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(origin);
        visited.add(origin.method_10063());
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 direction : class_2350.values()) {
                ReceiverOrganismComponentProvider provider;
                ReceiverOrganismComponent component;
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable.method_10063())) continue;
                visited.add(mutable.method_10063());
                class_2680 nextState = world.method_8320((class_2338)mutable);
                class_2248 class_22482 = nextState.method_26204();
                if (class_22482 instanceof ReceiverOrganismStructure) {
                    ReceiverOrganismStructure structure = (ReceiverOrganismStructure)class_22482;
                    structures.add(structure);
                    queue.add(mutable.method_10062());
                    continue;
                }
                class_22482 = nextState.method_26204();
                if (!(class_22482 instanceof ReceiverOrganismComponentProvider) || (component = (provider = (ReceiverOrganismComponentProvider)class_22482).get(world, (class_2338)mutable, nextState)) == null) continue;
                components.add(component);
            }
        }
    }

    private int placeExudate(int toPlace) {
        int placed = this.placeExudateInIncidentZone(this.field_11863, toPlace);
        if (placed < toPlace) {
            placed += this.extrudeExudate(this.field_11863, toPlace - placed);
        }
        return placed;
    }

    private int placeExudateInIncidentZone(class_1937 world, int toPlace) {
        int placed = 0;
        for (int i = 0; i < toPlace; ++i) {
            class_2338 randomPos = this.randomPosInSphere(this.field_11867, (float)this.parameters.getIncidentZoneRadius());
            class_2680 prevState = world.method_8320(randomPos);
            if (!this.canReplace(prevState) || !prevState.method_45474() && !this.random.method_43056()) continue;
            world.method_8501(randomPos, IntrusionReactor.ACTIVE_WASTE.method_9564());
            ++placed;
        }
        return placed;
    }

    private class_2338 randomPosInSphere(class_2338 origin, float radius) {
        float rx = this.random.method_43057() - 0.5f;
        float ry = this.random.method_43057() - 0.5f;
        float rz = this.random.method_43057() - 0.5f;
        float inverse = class_3532.method_48119((float)(rx * rx + ry * ry + rz * rz));
        float rl = inverse * this.random.method_43057() * radius;
        int x = origin.method_10263() + Math.round(rx * rl);
        int y = origin.method_10264() + Math.round(ry * rl);
        int z = origin.method_10260() + Math.round(rz * rl);
        return new class_2338(x, y, z);
    }

    private int extrudeExudate(class_1937 world, int toPlace) {
        List<class_2338> potential = this.traverse(world, this.lastOrigin, 800, toPlace);
        int canPlace = Math.min(potential.size(), toPlace);
        for (int i = 0; i < canPlace; ++i) {
            class_2338 pos = potential.get(potential.size() - i - 1);
            world.method_8501(pos, IntrusionReactor.ACTIVE_WASTE.method_9564());
        }
        this.lastOrigin = canPlace == 0 ? this.field_11867 : (!this.lastOrigin.equals((Object)this.field_11867) ? this.field_11867 : potential.get(potential.size() - 1));
        return canPlace;
    }

    private List<class_2338> traverse(class_1937 world, class_2338 origin, int maxVisit, int maxToPlace) {
        maxToPlace *= 2;
        class_2350[] horDirections = new class_2350[]{class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036};
        LongOpenHashSet visited = new LongOpenHashSet();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        if (!this.isValidBlock(world.method_8320(origin))) {
            return List.of();
        }
        visited.add(origin.method_10063());
        queue.add(origin);
        int blocksVisited = 0;
        while (!queue.isEmpty() && blocksVisited < maxVisit && positions.size() < maxToPlace) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            IntIterator intIterator = new IterateRandomly(horDirections.length).iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                class_2350 direction = horDirections[i];
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable.method_10063())) continue;
                visited.add(mutable.method_10063());
                class_2680 offsetState = world.method_8320((class_2338)mutable);
                if (offsetState.method_26215()) {
                    positions.add(mutable.method_10062());
                    continue;
                }
                if (!this.isValidBlock(offsetState)) continue;
                ++blocksVisited;
                queue.add(mutable.method_10062());
            }
        }
        return positions;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("age", this.age);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.age = nbt.method_10550("age");
    }

    @Override
    public void toClientTag(class_2487 nbt) {
        super.toClientTag(nbt);
        nbt.method_10549("incident_zone_radius", this.parameters.getIncidentZoneRadius());
    }

    @Override
    public void fromClientTag(class_2487 nbt) {
        super.fromClientTag(nbt);
        this.clientIncidentZoneRadius = nbt.method_10574("incident_zone_radius");
    }

    private boolean isValidBlock(class_2680 blockState) {
        return blockState.method_27852(IntrusionReactor.ACTIVE_WASTE) || blockState.method_27852(IntrusionReactor.REACTION_CORE) || blockState.method_26204() instanceof ReceiverOrganismStructure;
    }

    private boolean canReplace(class_2680 blockState) {
        return !this.isValidBlock(blockState) && !blockState.method_27852(IntrusionReactor.CORE_SENSOR) && !blockState.method_27852(NMBlocks.DATA_CABLE);
    }

    public void setDisruptorParams(int disruption, float maxOrgIncrease) {
        this.disruption = disruption;
        this.maxOrgIncrease = maxOrgIncrease;
    }
}

