/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.motor;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.processing.FluidEnegyRegistry;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMFluids;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;

public class LiquidFuelMachine
extends SyncableBlockEntity {
    protected WritableSingleFluidStorage fluidStorage = new WritableSingleFluidStorage(this.bufferCapacity(), this::method_5431);

    public LiquidFuelMachine(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public Storage<FluidVariant> getTank(class_2350 ignored) {
        return this.fluidStorage;
    }

    protected long maxPower() {
        return 1000L;
    }

    protected long bufferCapacity() {
        double baseEnergy = FluidEnegyRegistry.getInstance().getOrEmpty((class_3611)NMFluids.STILL_ETHEREAL_FUEL).baseEnergy();
        return (long)((double)this.maxPower() / baseEnergy);
    }

    public long extractEnergy(long abs, TransactionContext transaction) {
        FluidVariant variant = (FluidVariant)this.fluidStorage.getResource();
        if (!variant.isBlank()) {
            double baseEnergy = FluidEnegyRegistry.getInstance().getOrEmpty(variant.getFluid()).baseEnergy();
            long extractAmount = (long)((double)abs / baseEnergy);
            long extracted = this.fluidStorage.extract((TransferVariant)variant, extractAmount, transaction);
            return (long)((double)extracted * baseEnergy);
        }
        return 0L;
    }
}

