/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.mixer;

import com.google.common.base.Suppliers;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.block.entity.MotorisedMachineBlockEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.mixer.MixerStorage;
import com.neep.neepmeat.machine.mixer.MixingRecipe;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.particle.SwirlingParticleEffect;
import com.neep.neepmeat.transport.item_network.RetrievalTarget;
import com.neep.neepmeat.util.MiscUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.fluid.CauldronStorage;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class MixerBlockEntity
extends MotorisedMachineBlockEntity {
    protected final MixerStorage storage = new MixerStorage(this);
    @Nullable
    protected MixingRecipe currentRecipe;
    protected int processLength;
    protected float progress;
    protected int cooldownTicks = 2;
    protected long processStart;
    public float bladeAngle;
    public float bladeSpeed;
    private final Supplier<List<RetrievalTarget<FluidVariant>>> storageCaches = Suppliers.memoize(() -> {
        ObjectArrayList list = new ObjectArrayList();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166().method_10178()) continue;
            list.add(RetrievalTarget.of(FluidStorage.SIDED, (class_3218)this.method_10997(), this.method_11016().method_10093(direction), direction.method_10153()));
        }
        return new ObjectImmutableList((ObjectList)list);
    });
    @Nullable
    private List<Storage<FluidVariant>> adjacentStorageCache;

    public MixerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 0.04f, 2.0f);
    }

    public MixerBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.MIXER, pos, state);
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        return this.getExtractOutput();
    }

    public static WritableStackStorage getItemStorageFromTop(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 be, @Nullable class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos.method_10074());
        if (class_25862 instanceof MixerBlockEntity) {
            MixerBlockEntity mixer = (MixerBlockEntity)class_25862;
            return mixer.getItemStorage(class_2350.field_11036);
        }
        return null;
    }

    public static Storage<FluidVariant> getFluidStorageFromTop(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 be, @Nullable class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos.method_10074());
        if (class_25862 instanceof MixerBlockEntity) {
            MixerBlockEntity mixer = (MixerBlockEntity)class_25862;
            return mixer.getExtractOutput();
        }
        return null;
    }

    public WritableStackStorage getItemStorage(@Nullable class_2350 direction) {
        return this.storage.getItemInput();
    }

    public void setCurrentRecipe(@Nullable MixingRecipe recipe) {
        this.currentRecipe = recipe;
        this.cooldownTicks = 2;
    }

    public MixingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public List<Storage<FluidVariant>> getAdjacentStorages() {
        if (this.adjacentStorageCache == null) {
            this.adjacentStorageCache = new ObjectArrayList();
            for (RetrievalTarget<FluidVariant> cache : this.storageCaches.get()) {
                Storage<FluidVariant> storage = cache.find();
                if (storage == null || storage instanceof CauldronStorage) continue;
                this.adjacentStorageCache.add(storage);
            }
        }
        return this.adjacentStorageCache;
    }

    public Storage<FluidVariant> getOutputStorage() {
        return this.storage.getFluidOutput();
    }

    public Storage<FluidVariant> getExtractOutput() {
        return this.storage.getExtractOutput();
    }

    public void startDutyCycle() {
        MixingRecipe recipe;
        if (this.currentRecipe == null && (recipe = (MixingRecipe)MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.MIXING, this.storage).orElse(null)) != null && MeatlibStorageUtil.simulateInsert(this.getOutputStorage(), FluidVariant.of((class_3611)recipe.fluidOutput.resource()), recipe.fluidOutput.maxAmount(), null) == recipe.fluidOutput.maxAmount()) {
            try (Transaction transaction = Transaction.openOuter();){
                if (recipe.takeInputs(this.storage, (TransactionContext)transaction)) {
                    transaction.commit();
                    this.setCurrentRecipe(recipe);
                    this.processLength = recipe.processTime;
                    this.processStart = this.field_11863.method_8510();
                    this.sync();
                } else {
                    transaction.abort();
                }
            }
        }
    }

    public void endDutyCycle() {
        if (this.currentRecipe != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.getCurrentRecipe().ejectOutputs(this.storage, (TransactionContext)transaction)) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
            this.setCurrentRecipe(null);
        }
        this.sync();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.currentRecipe != null) {
            nbt.method_10582("current_recipe", this.currentRecipe.method_8114().toString());
        }
        nbt.method_10548("progress", this.progress);
        nbt.method_10569("process_time", this.processLength);
        nbt.method_10544("process_start", this.processStart);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.currentRecipe = MiscUtil.ifPresentOrNull(nbt, "current_recipe", s -> MeatlibRecipes.getInstance().get(class_2960.method_12829((String)s)).orElse(null));
        this.progress = nbt.method_10583("progress");
        this.processLength = nbt.method_10550("process_time");
        this.processStart = nbt.method_10537("process_start");
        this.storage.readNbt(nbt);
    }

    public void tick() {
        if (this.currentRecipe != null && this.progressIncrement > this.minPower) {
            this.progress = Math.min((float)this.processLength, this.progress + this.progressIncrement);
            if (this.progress >= (float)this.processLength) {
                this.endDutyCycle();
                this.progress = 0.0f;
            }
            this.sync();
        } else {
            this.progress += 1.0f;
            if (this.progress >= (float)this.cooldownTicks) {
                this.startDutyCycle();
                this.progress = 0.0f;
            }
        }
        if (this.currentRecipe == null || this.progressIncrement > this.minPower) {
            // empty if block
        }
        this.adjacentStorageCache = null;
    }

    public void dropItems() {
        try (Transaction transaction = Transaction.openOuter();){
            Iterator iterator = this.storage.itemInput.iterator();
            while (iterator.hasNext()) {
                StorageView view = (StorageView)iterator.next();
                class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)((ItemVariant)view.getResource()).toStack((int)view.getAmount()));
            }
            transaction.commit();
        }
    }

    public void spawnMixingParticles(FluidVariant ingredient, int count, double dy, double speed) {
        class_1937 class_19372;
        if (!ingredient.isBlank() && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)new SwirlingParticleEffect(NMParticles.BLOCK_SWIRL, ((class_3611)ingredient.getObject()).method_15785().method_15759(), 0.4, speed), (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5 + 1.0, (double)this.field_11867.method_10260() + 0.5, count, 0.0, dy, 0.0, 0.1);
        }
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.tick();
        return true;
    }
}

