/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.recipe.OreFatRenderingRecipe;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class PressurisedDigesterProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.STOMACH, LivingMachineComponents.FLUID_INPUT, LivingMachineComponents.FLUID_OUTPUT, LivingMachineComponents.ITEM_INPUT);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.STOMACH).ifPresent(result -> {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant processItem;
                DigesterStorage ctx = new DigesterStorage(be.getCombinedItemInput(), be.getCombinedFluidInput(), be.getCombinedFluidOutput());
                OreFatRenderingRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ORE_FAT_RENDERING, ctx).orElse(null);
                if (recipe != null && (processItem = recipe.takeInputs(ctx, 1, (TransactionContext)transaction)) != null) {
                    transaction.commit();
                }
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "pressurised_digester");
    }

    private record DigesterStorage(Storage<ItemVariant> itemInput, Storage<FluidVariant> fluidInput, Storage<FluidVariant> fluidOutput) implements CrucibleStorage
    {
        @Override
        public Storage<FluidVariant> getStorage(@Nullable class_2350 direction) {
            return this.fluidInput;
        }

        @Override
        public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
            return this.itemInput;
        }

        @Override
        public Storage<FluidVariant> getFluidOutput() {
            return this.fluidOutput;
        }
    }
}

