/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.phage_ray.PhageRayBlockEntity;
import com.neep.neepmeat.machine.phage_ray.PhageRayEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class PhageRayProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.PHAGE_RAY);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.PHAGE_RAY).ifPresent(result -> {
            boolean canHarvest = !be.getComponent(LivingMachineComponents.EXTRACTOR).isEmpty();
            PhageRayBlockEntity ray = (PhageRayBlockEntity)result.t1().iterator().next();
            PhageRayEntity entity = ray.getTetheredEntity();
            try (Transaction transaction = Transaction.openOuter();){
                if (entity != null) {
                    entity.tickProcess(canHarvest, be.getCombinedItemOutput(), (TransactionContext)transaction);
                }
                transaction.commit();
            }
        });
    }

    @Override
    public List<class_2561> getProblems(LivingMachineBlockEntity be) {
        return be.withComponents(LivingMachineComponents.PHAGE_RAY).map(result -> {
            ObjectArrayList problems = new ObjectArrayList();
            PhageRayBlockEntity pbe = (PhageRayBlockEntity)result.t1().iterator().next();
            if (pbe.getPower() <= pbe.minPower) {
                problems.add(class_2561.method_30163((String)("Power < " + PowerUtils.formatEnergy((long)(pbe.minPower * (float)PowerUtils.BASE_POWER), 0))));
            }
            return problems;
        }).orElse(List.of());
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "phage_ray");
    }

    public static interface PhageRay {
        public static final PhageRay EMPTY = new PhageRay(){

            @Override
            public boolean trigger() {
                return false;
            }

            @Override
            public class_243 getBeamOrigin() {
                return class_243.field_1353;
            }

            @Override
            public class_243 getClientBeamEnd(class_243 start, float tickDelta) {
                return class_243.field_1353;
            }

            @Override
            public int getAge() {
                return 0;
            }
        };

        public boolean trigger();

        public class_243 getBeamOrigin();

        public class_243 getClientBeamEnd(class_243 var1, float var2);

        public int getAge();
    }
}

