/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.CrusherSegmentBlockEntity;
import com.neep.neepmeat.machine.live_machine.block.entity.LargestHopperBlockEntity;
import com.neep.neepmeat.machine.live_machine.block.entity.LuckyOneBlockEntity;
import com.neep.neepmeat.machine.live_machine.component.ItemInputComponent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class CrusherProcess
implements Process {
    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.ITEM_INPUT, LivingMachineComponents.CRUSHER_SEGMENT, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT).ifPresent(result -> {
            Collection hoppers = result.t1();
            Collection crushers = result.t2();
            if (crushers.size() > 4) {
                return;
            }
            float chanceMod = 0.0f;
            Collection<LuckyOneBlockEntity> luckies = be.getComponent(LivingMachineComponents.LUCKY_ONE);
            for (LuckyOneBlockEntity lucky : luckies) {
                if ((double)chanceMod >= 0.2) break;
                if (!lucky.isActive()) continue;
                chanceMod += 0.1f;
            }
            if ((double)be.getPower() < 0.1) {
                return;
            }
            float progressIncrement = be.getProgressIncrement();
            ItemInputComponent hopper = (ItemInputComponent)hoppers.iterator().next();
            ObjectArrayList entityResultStacks = new ObjectArrayList();
            if (hopper instanceof LargestHopperBlockEntity) {
                LargestHopperBlockEntity hopperBlockEntity = (LargestHopperBlockEntity)hopper;
                hopperBlockEntity.damageEntities(progressIncrement, (List<class_1799>)entityResultStacks, luckies.size());
            }
            Storage<ItemVariant> input = be.getCombinedItemInput();
            Storage<ItemVariant> output = be.getCombinedItemOutput();
            ArrayList<Object> inputViews = new ArrayList<Object>();
            for (Object view : input) {
                if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
                inputViews.add(view);
            }
            try (Transaction transaction = Transaction.openOuter();){
                for (CrusherSegmentBlockEntity crusher : crushers) {
                    Transaction inner = transaction.openNested();
                    try {
                        CrusherSegmentBlockEntity.InputSlot slot = crusher.getStorage();
                        if (!inputViews.isEmpty() && slot.isEmpty()) {
                            be.inputSequence = (be.inputSequence + 1) % inputViews.size();
                            try (Transaction inner2 = inner.openNested();){
                                StorageView view = (StorageView)inputViews.get(be.inputSequence);
                                if (!view.isResourceBlank() && view.getAmount() > 0L) {
                                    long extracted;
                                    long inserted = slot.insert((TransferVariant)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)inner2);
                                    if (inserted == (extracted = view.extract((Object)((ItemVariant)view.getResource()), inserted, (TransactionContext)inner2))) {
                                        inner2.commit();
                                    } else {
                                        inner2.abort();
                                    }
                                }
                            }
                        }
                        if (!slot.isEmpty()) {
                            slot.tick(progressIncrement, output, chanceMod, (TransactionContext)inner);
                        }
                        inner.commit();
                    }
                    finally {
                        if (inner == null) continue;
                        inner.close();
                    }
                }
                if (!entityResultStacks.isEmpty()) {
                    try (Transaction inner = transaction.openNested();){
                        for (class_1799 stack : entityResultStacks) {
                            if (stack.method_7960()) continue;
                            output.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)inner);
                        }
                        inner.commit();
                    }
                }
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return List.of(LivingMachineComponents.ITEM_INPUT, LivingMachineComponents.CRUSHER_SEGMENT, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT);
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "crusher");
    }
}

