/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.meatlib.MeatLib;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpBlockEntity;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;
import net.minecraft.class_3611;

public class CharnelPumpProcess
implements Process {
    public static final long DISTRIBUTE_AMOUNT = 27000L;
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.CHARNEL_PUMP, LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.FLUID_INPUT);

    public static boolean canRun(double puPower, CharnelPumpBlockEntity be) {
        if (MeatLib.vsUtil == null) {
            return puPower >= (double)((Integer)NeepMeat.CONFIG.charnelPump.minPower.getRealValue()).intValue() / (double)PowerUtils.referencePower();
        }
        return puPower >= (double)((Integer)NeepMeat.CONFIG.charnelPump.minPower.getRealValue()).intValue() / (double)PowerUtils.referencePower() && !MeatLib.vsUtil.hasShipAtPosition(be.method_11016(), be.method_10997());
    }

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.CHARNEL_PUMP, LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.FLUID_INPUT).ifPresent(with -> {
            CharnelPumpBlockEntity pump = (CharnelPumpBlockEntity)with.t1().iterator().next();
            try (Transaction transaction = Transaction.openOuter();){
                Storage<FluidVariant> inputStorage = be.getCombinedFluidInput();
                pump.serverTick(be.getPower(), inputStorage, transaction);
                transaction.commit();
            }
        });
    }

    @Override
    public List<class_2561> getProblems(LivingMachineBlockEntity be) {
        return be.withComponents(LivingMachineComponents.CHARNEL_PUMP, LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.FLUID_INPUT).map(with -> {
            ObjectArrayList problems = new ObjectArrayList();
            if (!CharnelPumpProcess.canRun(be.getPower(), (CharnelPumpBlockEntity)with.t1().iterator().next())) {
                problems.add(class_2561.method_30163((String)("Power < " + PowerUtils.formatPower(((Integer)NeepMeat.CONFIG.charnelPump.minPower.getRealValue()).intValue(), 0))));
            }
            try (Transaction transaction = Transaction.openOuter();){
                long droplets = Math.max(10L, (long)(be.getPower() * (float)((Integer)NeepMeat.CONFIG.charnelPump.powerToAir.getRealValue()).intValue()));
                if (droplets != be.getCombinedFluidInput().extract((Object)FluidVariant.of(NMFluids.COMPRESSED_AIR.still()), droplets, (TransactionContext)transaction)) {
                    problems.add(class_2561.method_30163((String)"No compressed air"));
                }
                if (27000L != be.getCombinedFluidInput().extract((Object)FluidVariant.of((class_3611)NMFluids.STILL_WORK_FLUID), 27000L, (TransactionContext)transaction)) {
                    problems.add(class_2561.method_30163((String)"Integration fluid < 27000d"));
                }
                transaction.abort();
            }
            return problems;
        }).orElse(List.of());
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "charnel_pump");
    }
}

