/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.google.common.collect.Lists;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.processing.ball_mill.BallMillRecipe;
import com.neep.neepmeat.api.processing.ball_mill.BallMillRecipeGenerator;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.BallMillBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;

public class BallMillProcess
implements Process {
    private final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.ITEM_INPUT, LivingMachineComponents.BALL_MILL, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.BALL_MILL).ifPresent(r -> {
            Storage<ItemVariant> inputPorts = be.getCombinedItemInput();
            Storage<ItemVariant> output = be.getCombinedItemOutput();
            Collection mills = r.t1();
            if (mills.size() > 4 || be.getProgressIncrement() == 0.0f) {
                return;
            }
            ArrayList inputViews = Lists.newArrayList((Iterable)inputPorts.nonEmptyViews());
            try (Transaction transaction = Transaction.openOuter();){
                for (BallMillBlockEntity mill : mills) {
                    Transaction inner = transaction.openNested();
                    try {
                        if (!inputViews.isEmpty() && mill.inputSlot.isEmpty()) {
                            be.inputSequence = (be.inputSequence + 1) % inputViews.size();
                            try (Transaction inner2 = inner.openNested();){
                                StorageView view = (StorageView)inputViews.get(be.inputSequence);
                                Optional<BallMillRecipe> matching = BallMillRecipeGenerator.INSTANCE.getFirstMatch(new BallMillRecipe.BallMillContext.Match((StorageView<ItemVariant>)view));
                                if (matching.isPresent()) {
                                    long extracted;
                                    long inserted = mill.inputSlot.insert((TransferVariant)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)inner2);
                                    if (inserted == (extracted = view.extract((Object)((ItemVariant)view.getResource()), inserted, (TransactionContext)inner2))) {
                                        inner2.commit();
                                    } else {
                                        inner2.abort();
                                    }
                                }
                            }
                        }
                        if (!mill.inputSlot.isEmpty()) {
                            mill.inputSlot.tick(be.getProgressIncrement(), output, 0.0f, (TransactionContext)inner);
                        }
                        inner.commit();
                    }
                    finally {
                        if (inner == null) continue;
                        inner.close();
                    }
                }
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return this.REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "ball_mill");
    }
}

