/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.large_crusher;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.client.renderer.BERenderUtils;
import com.neep.neepmeat.machine.large_crusher.LargeCrusherBlock;
import com.neep.neepmeat.machine.large_crusher.LargeCrusherBlockEntity;
import com.neep.neepmeat.util.NMMaths;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class LargeCrusherVisual
extends AbstractBlockEntityVisual<LargeCrusherBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance jawModel;
    private final TransformedInstance sheathModel;
    private final class_4587 matrixStack;

    public LargeCrusherVisual(VisualizationContext ctx, LargeCrusherBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.jawModel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.LARGE_CRUSHER_JAW)).createInstance();
        this.sheathModel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.LARGE_CRUSHER_SHEATH)).createInstance();
        this.matrixStack = new class_4587();
        this.matrixStack.method_46416((float)this.getVisualPosition().method_10263(), (float)this.getVisualPosition().method_10264(), (float)this.getVisualPosition().method_10260());
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (!((Boolean)((LargeCrusherBlockEntity)this.blockEntity).method_11010().method_11654((class_2769)LargeCrusherBlock.ASSEMBLED)).booleanValue()) {
            this.jawModel.scale(0.0f, 0.0f, 0.0f);
            this.sheathModel.scale(0.0f, 0.0f, 0.0f);
            return;
        }
        float tickDelta = context.partialTick();
        float sinTime1 = NMMaths.sin(((LargeCrusherBlockEntity)this.blockEntity).method_10997().method_8510(), tickDelta, 1.0f);
        float sinTime2 = NMMaths.sin(((LargeCrusherBlockEntity)this.blockEntity).method_10997().method_8510(), tickDelta, 2.0f);
        this.matrixStack.method_22903();
        class_2350 facing = (class_2350)((LargeCrusherBlockEntity)this.blockEntity).method_11010().method_11654((class_2769)LargeCrusherBlock.FACING);
        if (((LargeCrusherBlockEntity)this.blockEntity).progressIncrement() > ((LargeCrusherBlockEntity)this.blockEntity).minPower) {
            Vector3f unit = facing.method_23955();
            double magnitude = Math.abs(0.05 * (double)sinTime1);
            this.matrixStack.method_22904((double)unit.x * magnitude, 0.0, (double)unit.z * magnitude);
        }
        BERenderUtils.rotateFacing(facing, this.matrixStack);
        this.jawModel.setTransform(this.matrixStack);
        this.matrixStack.method_22909();
        this.matrixStack.method_22903();
        if (((LargeCrusherBlockEntity)this.blockEntity).progressIncrement() > ((LargeCrusherBlockEntity)this.blockEntity).minPower) {
            this.matrixStack.method_22904(0.0, (double)sinTime2 * 0.03, 0.0);
        }
        BERenderUtils.rotateFacing(facing, this.matrixStack);
        this.sheathModel.setTransform(this.matrixStack);
        this.matrixStack.method_22909();
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.jawModel, this.sheathModel});
    }

    public void _delete() {
        this.jawModel.delete();
        this.sheathModel.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

