/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.large_crusher;

import com.neep.meatlib.entity.MobKillUtil;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.block.entity.MotorisedMachineBlockEntity;
import com.neep.neepmeat.machine.large_crusher.LargeCrusherBlock;
import com.neep.neepmeat.machine.large_crusher.LargeCrusherStorage;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class LargeCrusherBlockEntity
extends MotorisedMachineBlockEntity
implements MotorisedBlock {
    protected final LargeCrusherStorage storage = new LargeCrusherStorage(this);
    private final Random jrandom = new Random();
    public int previewTicks = 0;

    public LargeCrusherBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 0.2f, 2.0f);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
    }

    public void serverTick(class_3218 world) {
        super.serverTick();
        if (!((Boolean)this.method_11010().method_11654((class_2769)LargeCrusherBlock.ASSEMBLED)).booleanValue()) {
            this.power = 0.0f;
            this.progressIncrement = 0.0f;
            return;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)LargeCrusherBlock.FACING);
        if (world.method_8510() % 4L == 0L) {
            class_2350 clockwise = facing.method_10170();
            class_2350 aclockwise = facing.method_10160();
            class_238 box = new class_238(this.field_11867.method_10086(2)).method_989((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165()).method_1012((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165()).method_1012((double)clockwise.method_10148(), (double)clockwise.method_10164(), (double)clockwise.method_10165()).method_1012((double)aclockwise.method_10148(), (double)aclockwise.method_10164(), (double)aclockwise.method_10165());
            List entities = world.method_8390(class_1297.class, box, e -> true);
            entities.stream().filter(e -> e instanceof class_1542).map(class_1542.class::cast).findFirst().ifPresent(item -> {
                try (Transaction transaction = Transaction.openOuter();){
                    ItemVariant variant = ItemVariant.of((class_1799)item.method_6983());
                    long inserted = this.storage.inputStorage.insert((Object)variant, (long)item.method_6983().method_7947(), (TransactionContext)transaction);
                    item.method_6983().method_7934((int)inserted);
                    transaction.commit();
                }
            });
            if (world.method_8510() % 8L == 0L) {
                float damageAmount = this.power * 20.0f;
                class_1282 damageSource = world.method_48963().method_48830();
                ArrayList resultStacks = new ArrayList();
                entities.stream().filter(e -> e instanceof class_1309).map(class_1309.class::cast).forEach(entity -> {
                    if (entity.method_5805() && entity.method_33190() && entity.field_6235 == 0) {
                        if (entity.method_6032() <= damageAmount) {
                            MobKillUtil.dropLoot(world, entity, damageSource, resultStacks, true, 0);
                            entity.setDropsLoot(false);
                            entity.method_5768();
                        }
                        entity.method_5643(damageSource, 4.0f);
                    }
                });
                if (!resultStacks.isEmpty()) {
                    try (Transaction transaction = Transaction.openOuter();){
                        resultStacks.forEach(stack -> this.storage.outputStorage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction));
                        transaction.commit();
                    }
                }
            }
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (Object view : this.storage.outputStorage) {
                if (view.isResourceBlank()) continue;
                int extracted = (int)ItemPipeUtil.EjectOperation.of((class_1937)world, this.field_11867.method_10093(facing), class_2350.field_11033).useRouting(true).stackToAny((ItemVariant)view.getResource(), view.getAmount(), (TransactionContext)transaction).amount();
                view.extract((Object)((ItemVariant)view.getResource()), (long)extracted, (TransactionContext)transaction);
            }
            transaction.commit();
        }
        transaction = Transaction.openOuter();
        try {
            int occupied = 0;
            for (LargeCrusherStorage.InputSlot slot : this.storage.slots) {
                if (slot.getRecipe() == null) continue;
                ++occupied;
            }
            float progressIncrement = this.progressIncrement() * 4.0f / (float)occupied;
            for (LargeCrusherStorage.InputSlot slot : this.storage.slots) {
                slot.tick(progressIncrement, (TransactionContext)transaction);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        return false;
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        if (((Boolean)this.method_11010().method_11654((class_2769)LargeCrusherBlock.ASSEMBLED)).booleanValue()) {
            return super.getDiagnostics();
        }
        return null;
    }

    public Storage<ItemVariant> getInputStorage(class_2350 unused) {
        return this.storage.inputStorage;
    }

    public List<LargeCrusherStorage.InputSlot> getSlots() {
        return this.storage.slots;
    }

    public void preview() {
        this.previewTicks = 30;
    }

    public void clientTick() {
        this.previewTicks = Math.max(0, this.previewTicks - 1);
        if (!((Boolean)this.method_11010().method_11654((class_2769)LargeCrusherBlock.ASSEMBLED)).booleanValue()) {
            return;
        }
        float intensity = this.progressIncrement / this.maxIncrement;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)LargeCrusherBlock.FACING);
        int tickInterval = (int)class_3532.method_15363((float)1.0f, (float)(1.0f / (intensity * 2.0f)), (float)100.0f);
        if (this.field_11863.method_8510() % (long)tickInterval == 0L && this.progressIncrement() >= this.minPower) {
            int[] indices;
            for (int idx : indices = this.jrandom.ints(this.storage.slots.size(), 0, this.storage.slots.size()).toArray()) {
                LargeCrusherStorage.InputSlot slot = this.storage.slots.get(idx);
                if (slot.isEmpty() || slot.getRecipe() == null) continue;
                double px = (double)this.method_11016().method_10263() + (double)facing.method_10148() * 0.5 + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 1.0;
                double py = (double)this.method_11016().method_10264() + 2.5 + ((double)this.jrandom.nextFloat() - 0.5) * 0.5;
                double pz = (double)(this.method_11016().method_10260() - 1) + (double)facing.method_10165() * 0.5 + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 1.0;
                double vx = ((double)this.jrandom.nextFloat() - 0.5) * 0.2;
                double vy = (double)this.jrandom.nextFloat() * Math.max(0.3, (double)intensity);
                double vz = ((double)this.jrandom.nextFloat() - 0.5) * 0.2;
                this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, slot.getAsStack()), px, py, pz, vx, vy, vz);
            }
        }
    }
}

