/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.integrator;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.DataResource;
import com.neep.neepmeat.api.data.DataUtil;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.machine.integrator.Integrator;
import com.neep.neepmeat.machine.integrator.IntegratorStorage;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IntegratorBlockEntity
extends SyncableBlockEntity
implements Integrator,
GeoBlockEntity {
    protected int growthTimeRemaining = 1000;
    protected final IntegratorStorage storage;
    protected class_2338 lookTarget = new class_2338(0, 0, 0);
    public boolean isMature = false;
    public float facing = 0.0f;
    public float targetFacing = 0.0f;
    public static final long MAX_DATA = 8192L;
    protected long data;
    public final long animationOffset = (long)(Math.random() * 20.0);
    protected SnapshotParticipant<Long> dataSnapshot = new SnapshotParticipant<Long>(){

        protected Long createSnapshot() {
            return IntegratorBlockEntity.this.data;
        }

        protected void readSnapshot(Long snapshot) {
            IntegratorBlockEntity.this.data = snapshot;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            IntegratorBlockEntity.this.sync();
        }
    };
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hatching;
    public static final Map<class_1792, Integer> DATA_MAP = Map.of(NMItems.WHISPER_FLOUR, 500);

    public IntegratorBlockEntity(class_2338 pos, class_2680 state) {
        super(NMBlockEntities.INTEGRATOR, pos, state);
        this.storage = new IntegratorStorage(this);
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("growth_remaining", this.growthTimeRemaining);
        tag.method_10556("fully_grown", this.isMature);
        tag.method_10566("lookTarget", (class_2520)class_2512.method_10692((class_2338)this.lookTarget));
        tag.method_10544("data", this.data);
        this.storage.writeNbt(tag);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.growthTimeRemaining = tag.method_10550("growth_remaining");
        this.isMature = tag.method_10577("fully_grown");
        this.lookTarget = class_2512.method_10691((class_2487)tag.method_10562("lookTarget"));
        this.data = tag.method_10537("data");
        this.storage.readNbt(tag);
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, IntegratorBlockEntity be) {
        if (be.canGrow()) {
            be.grow();
            be.sync();
        }
        if (be.isMature) {
            be.data = Math.min(8192L, be.data + 1L);
            if (world.method_8510() % 20L == 0L) {
                be.sync();
            }
            if (world.method_8510() % 60L == 0L) {
                be.pointToEntity();
            }
        }
    }

    public void pointToEntity() {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867);
        if (class_25862 instanceof IntegratorBlockEntity) {
            IntegratorBlockEntity be = (IntegratorBlockEntity)class_25862;
            class_238 box = new class_238((double)(this.field_11867.method_10263() - 2), (double)(this.field_11867.method_10264() - 2), (double)(this.field_11867.method_10260() - 2), (double)(this.field_11867.method_10263() + 3), (double)(this.field_11867.method_10264() + 3), (double)(this.field_11867.method_10260() + 3));
            List players = be.method_10997().method_18023(class_5575.method_31795(class_1297.class), box, e -> true);
            if (players.size() > 0) {
                be.setLookPos(((class_1297)players.get(0)).method_24515());
                this.sync();
            }
        }
    }

    public boolean canGrow() {
        return !this.isMature && this.storage.immatureStorage.getAmount() == this.storage.immatureStorage.capacity;
    }

    public void grow() {
        if (this.storage.immatureStorage.getAmount() >= this.storage.immatureStorage.getCapacity()) {
            --this.growthTimeRemaining;
        }
        if (this.growthTimeRemaining <= 0) {
            this.isMature = true;
        }
    }

    public boolean takeFromHand(class_1657 player, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand);
        Integer inc = DATA_MAP.get(handStack.method_7909());
        if (inc != null) {
            try (Transaction transaction = Transaction.openOuter();){
                float ins = this.insertEnlightenment(inc.intValue(), (TransactionContext)transaction);
                if (ins == (float)inc.intValue()) {
                    transaction.commit();
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15099, class_3419.field_15245, 1.0f, 1.0f);
                    handStack.method_7934(1);
                    boolean bl = true;
                    return bl;
                }
                transaction.abort();
            }
        }
        return false;
    }

    public void showContents(class_3222 player) {
        if (!this.canEnlighten()) {
            int percent = (int)((float)this.storage.immatureStorage.getAmount() / 81000.0f * 100.0f);
            player.method_7353(class_2561.method_30163((String)("Blood: " + percent + "%")), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.neepmeat.integrator.data", (Object[])new Object[]{DataUtil.formatData(this.data), DataUtil.formatData(8192L)}), true);
        }
    }

    private <E extends GeoBlockEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().transitionLength(20);
        if (this.hatching) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.integrator.hatch"));
            this.hatching = false;
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.integrator.flex"));
        }
        return PlayState.CONTINUE;
    }

    public Storage<FluidVariant> getStorage(class_1937 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return this.storage.getFluidStorage(world, pos, state, direction);
    }

    public Storage<ItemVariant> getItemStorage(class_2350 direction) {
        return this.storage.itemStorage;
    }

    public float insertEnlightenment(float maxAmount, TransactionContext transaction) {
        float inserted = Math.min((float)(8192L - this.data), maxAmount);
        if (inserted > 0.0f) {
            this.dataSnapshot.updateSnapshots(transaction);
            this.data = (long)((float)this.data + inserted);
            return inserted;
        }
        return 0.0f;
    }

    @Override
    public boolean canEnlighten() {
        return this.isMature;
    }

    @Override
    public class_2338 getBlockPos() {
        return this.method_11016();
    }

    @Override
    public void setLookPos(class_2338 pos) {
        this.lookTarget = pos;
        this.sync();
    }

    @Override
    public void spawnBeam(class_1937 world, class_2338 pos) {
        Integrator.spawnBeam((class_3218)world, this.method_11016().method_10084(), pos);
        world.method_8396(null, pos, NMSounds.COSMIC_BEAM, class_3419.field_15245, 1.0f, 0.8f);
    }

    @Override
    public long getData(DataResource variant) {
        return this.data;
    }

    @Override
    public float extract(DataResource variant, long amount, TransactionContext transaction) {
        long extracted = Math.min(amount, this.data);
        if (extracted > 0L) {
            this.dataSnapshot.updateSnapshots(transaction);
            this.data -= extracted;
            return extracted;
        }
        return 0.0f;
    }

    public class_243 getLookTarget() {
        return class_243.method_24953((class_2382)this.lookTarget);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

