/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.hydraulic_press;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.hydraulic_press.HydraulicPressBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class HydraulicPressVisual
extends AbstractBlockEntityVisual<HydraulicPressBlockEntity>
implements SimpleDynamicVisual {
    public static final float MAX_DISPLACEMENT = 0.54f;
    private final TransformedInstance arm;

    public HydraulicPressVisual(VisualizationContext ctx, HydraulicPressBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.arm = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.HYDRAULIC_PRESS_ARM)).createInstance();
        ((TransformedInstance)this.arm.setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, -0.54f * blockEntity.renderExtension, 0.0f).setChanged();
    }

    public void _delete() {
        this.arm.delete();
    }

    public void beginFrame(DynamicVisual.Context context) {
        WritableSingleFluidStorage storage = ((HydraulicPressBlockEntity)this.blockEntity).getStorage(null);
        float extension = (float)storage.getAmount() / 81000.0f;
        float prevRenderExtension = ((HydraulicPressBlockEntity)this.blockEntity).renderExtension;
        ((HydraulicPressBlockEntity)this.blockEntity).renderExtension = class_3532.method_16439((float)0.1f, (float)((HydraulicPressBlockEntity)this.blockEntity).renderExtension, (float)extension);
        ((TransformedInstance)this.arm.setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, -0.54f * ((HydraulicPressBlockEntity)this.blockEntity).renderExtension, 0.0f);
        if (((HydraulicPressBlockEntity)this.blockEntity).renderExtension != prevRenderExtension) {
            this.arm.setChanged();
        }
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.arm});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

