/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.homogeniser;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.homogeniser.HomogeniserStorage;
import com.neep.neepmeat.machine.homogeniser.MeatAdditives;
import com.neep.neepmeat.machine.motor.MotorEntity;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class HomogeniserBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    protected HomogeniserStorage storage = new HomogeniserStorage(this);
    protected State state = State.IDLE;
    protected final float maxProgress = 20.0f;
    protected float progress = 0.0f;
    protected float power = 0.0f;
    float angle = 0.0f;

    public HomogeniserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10569("state", this.state.ordinal());
        nbt.method_10548("progress", this.progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.state = State.values()[nbt.method_10550("state")];
        this.progress = nbt.method_10583("progress");
    }

    public WritableStackStorage getItemStorage(@Nullable class_2350 direction) {
        return this.storage.itemStorage;
    }

    public HomogeniserStorage getStorage() {
        return this.storage;
    }

    protected boolean canProcess(TransactionContext transaction) {
        MeatAdditives.Entry entry;
        WritableStackStorage inputItemStorage = this.storage.itemStorage;
        if (!inputItemStorage.isEmpty() && (entry = MeatAdditives.getInstance().get(((ItemVariant)inputItemStorage.getResource()).getItem())) != null) {
            try (Transaction test = transaction.openNested();){
                Storage<FluidVariant> inputFluidStorage = this.storage.getInputFluidStorage();
                ResourceAmount inputVariant = StorageUtil.findExtractableContent(inputFluidStorage, v -> v.isOf((Object)NMFluids.STILL_C_MEAT), (TransactionContext)test);
                if (inputVariant != null && entry.canApply((FluidVariant)inputVariant.resource()) && inputVariant.amount() >= entry.getAmount()) {
                    test.abort();
                    boolean bl = true;
                    return bl;
                }
                test.abort();
            }
        }
        return false;
    }

    protected void ejectOutput(TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            MeatAdditives.Entry entry;
            WritableStackStorage inputItemStorage = this.storage.itemStorage;
            if (!inputItemStorage.isEmpty() && (entry = MeatAdditives.getInstance().get(((ItemVariant)inputItemStorage.getResource()).getItem())) != null) {
                Storage<FluidVariant> inputFluidStorage = this.storage.getInputFluidStorage();
                Storage<FluidVariant> outputFluidStorage = this.storage.getOutputStorage();
                ResourceAmount inputVariant = StorageUtil.findExtractableContent(inputFluidStorage, v -> v.isOf((Object)NMFluids.STILL_C_MEAT), (TransactionContext)inner);
                if (inputVariant != null && entry.canApply((FluidVariant)inputVariant.resource()) && inputVariant.amount() >= entry.getAmount()) {
                    long extracted = inputFluidStorage.extract((Object)((FluidVariant)inputVariant.resource()), entry.getAmount(), (TransactionContext)inner);
                    FluidVariant outputVariant = entry.apply((FluidVariant)inputVariant.resource());
                    long inserted = outputFluidStorage.insert((Object)outputVariant, extracted, (TransactionContext)inner);
                    if (inserted == extracted) {
                        inner.commit();
                        return;
                    }
                }
                inner.abort();
            }
        }
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        try (Transaction transaction = Transaction.openOuter();){
            switch (this.state) {
                case IDLE: {
                    if (this.field_11863.method_8510() % 2L != 0L || !this.canProcess((TransactionContext)transaction)) break;
                    this.progress = 0.0f;
                    this.state = State.PROCESSING;
                    this.sync();
                    break;
                }
                case PROCESSING: {
                    this.progress = Math.min(20.0f, this.progress + this.power);
                    if (this.progress != 20.0f) break;
                    this.progress = 0.0f;
                    this.ejectOutput((TransactionContext)transaction);
                    this.state = State.IDLE;
                    this.sync();
                }
            }
            transaction.commit();
        }
        return true;
    }

    public void clientTick() {
        this.angle = (float)((double)this.angle + 1.1);
        if (this.state == State.PROCESSING && !this.storage.itemStorage.isEmpty()) {
            double radius = 0.2;
            double cx = (double)this.method_11016().method_10263() + 0.5;
            double cy = this.method_11016().method_10264() + 1;
            double cz = (double)this.method_11016().method_10260() + 0.5;
            double px = cx + Math.sin(this.angle) * radius;
            double pz = cz + Math.cos(this.angle) * radius;
            double vx = (px - cx) * 0.5;
            double vy = 0.35;
            double vz = (pz - cz) * 0.5;
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, this.storage.itemStorage.getAsStack()), px, cy, pz, vx, vy, vz);
        }
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
    }

    @Override
    public float getLoadTorque() {
        return MotorisedBlock.super.getLoadTorque();
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(false, this.power, 0.0f);
    }

    protected static enum State {
        IDLE,
        PROCESSING;

    }
}

