/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fluid_rationer;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.storage.DynamicLazyBlockApiCache;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.machine.fluid_rationer.FluidRationerBlock;
import com.neep.neepmeat.machine.fluid_rationer.FluidRationerStorage;
import com.neep.neepmeat.screen_handler.FluidRationerScreenHandler;
import com.neep.neepmeat.transport.api.AutoEjector;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class FluidRationerBlockEntity
extends SyncableBlockEntity
implements ExtendedScreenHandlerFactory,
ConfigProvider {
    protected final FluidRationerStorage outputStorage;
    protected AcceptorModes inMode = AcceptorModes.PULL;
    protected AcceptorModes outMode = AcceptorModes.EXTRACT_ONLY;
    protected final FluidPump outPump = FluidPump.of(-0.1f, this::getOutMode);
    protected State state;
    private final WritePort writeAmount = this::receiveAmount;
    private final WritePort writeEject = this::receiveActivate;
    private boolean activateSignalReceived;
    protected final NeepBusConfig config = NeepBusConfig.builder(this::method_5431).input(new SimpleEntry("Eject amount"), this.writeAmount).input(new SimpleEntry("Eject"), this.writeEject).build();
    protected final LazyBlockApiCache<Storage<FluidVariant>, class_2350> cache;
    protected final AutoEjector<FluidVariant> ejector;
    protected int targetAmount = 81000;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FluidRationerBlockEntity.this.targetAmount;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FluidRationerBlockEntity.this.targetAmount = value;
                }
            }
            FluidRationerBlockEntity.this.method_5431();
        }

        public int method_17389() {
            return FluidRationerScreenHandler.PROPERTIES;
        }
    };

    public FluidRationerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.outputStorage = new FluidRationerStorage(324000L, this::method_5431);
        this.state = State.IDLE;
        this.cache = DynamicLazyBlockApiCache.facing(FluidStorage.SIDED, (class_2586)this, () -> ((class_2350)this.method_11010().method_11654((class_2769)FluidRationerBlock.field_10927)).method_10153());
        this.ejector = AutoEjector.simpleFluid(() -> (class_2350)this.method_11010().method_11654((class_2769)FluidRationerBlock.field_10927), this, (Storage<FluidVariant>)this.outputStorage, this.outPump);
    }

    public FluidRationerBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.FLUID_RATIONER, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, FluidRationerBlockEntity be) {
        be.tickInput();
    }

    protected void tickInput() {
        if (this.state == State.IDLE && this.field_11863.method_8510() % 2L == 0L && (((Boolean)this.method_11010().method_11654((class_2769)FluidRationerBlock.ACTIVE)).booleanValue() || this.activateSignalReceived)) {
            this.activateSignalReceived = false;
            try (Transaction transaction = Transaction.openOuter();){
                Storage<FluidVariant> storage = this.cache.find();
                if (storage == null) {
                    return;
                }
                for (StorageView view : storage) {
                    long extracted;
                    FluidVariant variant = (FluidVariant)view.getResource();
                    if (view.isResourceBlank() || view.getAmount() < (long)this.targetAmount || !this.outputStorage.matchesFilter(variant) || (extracted = view.extract((Object)variant, (long)this.targetAmount, (TransactionContext)transaction)) != (long)this.targetAmount || this.outputStorage.insert(variant, (long)this.targetAmount, (TransactionContext)transaction) != (long)this.targetAmount) continue;
                    this.state = State.PUSHING;
                    this.inMode = AcceptorModes.NONE;
                    this.outMode = AcceptorModes.PUSH;
                    transaction.commit();
                }
            }
        } else if (this.state == State.PUSHING) {
            this.ejector.tick(null);
            if (this.outputStorage.getAmount() == 0L) {
                this.state = State.IDLE;
                this.inMode = AcceptorModes.PULL;
                this.outMode = AcceptorModes.EXTRACT_ONLY;
            }
        }
    }

    private AcceptorModes getInMode() {
        return this.inMode;
    }

    private AcceptorModes getOutMode() {
        return this.outMode;
    }

    public Storage<FluidVariant> getStorage(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FluidRationerBlock.field_10927);
        if (direction == null || direction == facing) {
            return this.outputStorage;
        }
        return null;
    }

    public FluidPump getPump(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FluidRationerBlock.field_10927);
        if (direction == facing) {
            return this.outPump;
        }
        return null;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.outputStorage.toNbt(nbt);
        nbt.method_10569("state", this.state.ordinal());
        nbt.method_10569("inMode", this.inMode.ordinal());
        nbt.method_10569("outMode", this.outMode.ordinal());
        nbt.method_10569("targetAmount", this.targetAmount);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.outputStorage.readNbt(nbt);
        this.state = State.values()[nbt.method_10550("state")];
        this.inMode = AcceptorModes.values()[nbt.method_10550("inMode")];
        this.outMode = AcceptorModes.values()[nbt.method_10550("outMode")];
        this.targetAmount = nbt.method_10550("targetAmount");
        this.config.readNbt(nbt.method_10562("config"));
    }

    public class_2561 method_5476() {
        return NMBlocks.FLUID_RATIONER.method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FluidRationerScreenHandler(syncId, inv, (class_1263)this.outputStorage.inventory, this.propertyDelegate);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10804(this.targetAmount);
    }

    private void receiveAmount(DataVariant amount) {
        this.targetAmount = Math.max(0, amount.intValue());
        this.method_5431();
    }

    private void receiveActivate(DataVariant value) {
        if (value.floatValue() > 0.0f) {
            this.activateSignalReceived = true;
        }
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public static enum State {
        IDLE,
        PUSHING;

    }
}

