/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fluid_exciter;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.processing.FluidEnegyRegistry;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.fluid_exciter.AbstractVascularConduitEntity;
import com.neep.neepmeat.transport.api.BlockEntityUnloadListener;
import com.neep.neepmeat.transport.api.pipe.AbstractBloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.BloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntityProvider;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FluidExciterBlockEntity
extends SyncableBlockEntity
implements BlockEntityUnloadListener,
VascularConduitEntityProvider {
    protected long output;
    protected long injectedOutput;
    protected BlockApiCache<Storage<FluidVariant>, class_2350> downCache;
    protected SingleVariantStorage<FluidVariant> inputStorage = new WritableSingleFluidStorage(2430000L, this::method_5431){

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)NMFluids.STILL_ETHEREAL_FUEL);
        }

        @Override
        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            class_3218 serverWorld;
            class_1937 class_19372;
            if (FluidExciterBlockEntity.this.downCache == null) {
                FluidExciterBlockEntity.this.updateCache();
            }
            if (!((class_19372 = FluidExciterBlockEntity.this.field_11863) instanceof class_3218) || !(serverWorld = (class_3218)class_19372).method_8503().method_18854()) {
                return 0L;
            }
            double baseEnergy1 = FluidEnegyRegistry.getInstance().getOrEmpty(insertedVariant.getFluid()).baseEnergy() * 1.5;
            FluidExciterBlockEntity.this.output = (long)Math.ceil(baseEnergy1 * (double)maxAmount);
            return maxAmount;
        }

        protected boolean canExtract(FluidVariant variant) {
            return false;
        }

        public boolean supportsExtraction() {
            return false;
        }
    };
    private final BloodAcceptor bloodAcceptor = new AbstractBloodAcceptor(){

        @Override
        public long getOutput() {
            FluidExciterBlockEntity.this.injectedOutput = FluidExciterBlockEntity.this.output;
            FluidExciterBlockEntity.this.output = 0L;
            return FluidExciterBlockEntity.this.injectedOutput;
        }

        @Override
        public BloodAcceptor.Mode getMode() {
            return BloodAcceptor.Mode.SOURCE;
        }
    };
    private final AbstractVascularConduitEntity conduitEntity = new AbstractVascularConduitEntity(this.field_11867);

    public FluidExciterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void updateCache() {
        this.downCache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10074());
    }

    public SingleVariantStorage<FluidVariant> getInputStorage(class_2350 direction) {
        return this.inputStorage;
    }

    public static BloodAcceptor getBloodAcceptorFromTop(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos.method_10074());
        if (class_25862 instanceof FluidExciterBlockEntity) {
            FluidExciterBlockEntity be = (FluidExciterBlockEntity)class_25862;
            return be.bloodAcceptor;
        }
        return null;
    }

    public AbstractVascularConduitEntity getConduitEntity(Void unused) {
        return this.conduitEntity;
    }

    public void method_11012() {
        this.conduitEntity.onRemove();
        super.method_11012();
    }

    @Override
    public void onUnload(class_2818 chunk) {
        this.conduitEntity.onUnload();
    }

    @Override
    public VascularConduitEntity get() {
        return this.conduitEntity;
    }

    public long getOutput() {
        return this.injectedOutput;
    }
}

