/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.neep.neepmeat.machine.fabricator.FabricatorBlockEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public class RecipeMatching {
    static Collection<Residual> findMatchingWithResiduals(int batchSize, List<Storage<ItemVariant>> inputs, List<class_1856> ingredients, TransactionContext transaction) throws FabricatorLoopException {
        HashMap residuals1 = new HashMap();
        ingredients.forEach(i -> {
            if (!i.method_8103()) {
                Residual residual = residuals1.computeIfAbsent(i, i1 -> new Residual((class_1856)i, 0));
                residual.residual += (long)batchSize;
            }
        });
        Collection<Residual> residuals = residuals1.values();
        for (Storage<ItemVariant> storage : inputs) {
            for (StorageView view : storage.nonEmptyViews()) {
                if (residuals.isEmpty()) {
                    return residuals;
                }
                if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
                ItemVariant resource = (ItemVariant)view.getResource();
                Iterator<Residual> it = residuals.iterator();
                while (it.hasNext()) {
                    Residual residual = it.next();
                    if (residual.ingredient.method_8103()) {
                        it.remove();
                        continue;
                    }
                    ItemVariant extractedVariant = (ItemVariant)view.getResource();
                    if (!residual.ingredient.method_8093(extractedVariant.toStack())) continue;
                    if (view instanceof FabricatorBlockEntity.FabricatorStorage) {
                        FabricatorBlockEntity.FabricatorStorage fabricatorStorage = (FabricatorBlockEntity.FabricatorStorage)view;
                        throw new FabricatorLoopException();
                    }
                    long extracted = view.extract((Object)resource, residual.residual, transaction);
                    if (extracted == residual.residual) {
                        class_1799 remainder = extractedVariant.getItem().getRecipeRemainder(extractedVariant.toStack(batchSize));
                        if (extractedVariant.getItem().method_7858() != null) {
                            storage.insert((Object)ItemVariant.of((class_1799)remainder), (long)remainder.method_7947(), transaction);
                        }
                        it.remove();
                        continue;
                    }
                    residual.residual -= extracted;
                }
            }
        }
        return residuals;
    }

    static boolean findMatching(List<Storage<ItemVariant>> inputs, List<class_1856> ingredients, List<ItemVariant> takenResources, TransactionContext transaction) throws FabricatorLoopException {
        for (Storage<ItemVariant> storage : inputs) {
            for (StorageView view : storage.nonEmptyViews()) {
                if (ingredients.isEmpty()) {
                    return true;
                }
                if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
                ItemVariant resource = (ItemVariant)view.getResource();
                Iterator<class_1856> it = ingredients.iterator();
                while (it.hasNext()) {
                    class_1856 ingredient = it.next();
                    if (ingredient.method_8103()) {
                        it.remove();
                        continue;
                    }
                    ItemVariant extractedVariant = (ItemVariant)view.getResource();
                    if (!ingredient.method_8093(extractedVariant.toStack())) continue;
                    if (view instanceof FabricatorBlockEntity.FabricatorStorage) {
                        FabricatorBlockEntity.FabricatorStorage fabricatorStorage = (FabricatorBlockEntity.FabricatorStorage)view;
                        throw new FabricatorLoopException();
                    }
                    long extracted = view.extract((Object)resource, 1L, transaction);
                    if (extracted != 1L) continue;
                    takenResources.add(extractedVariant);
                    class_1799 remainder = extractedVariant.getItem().getRecipeRemainder(extractedVariant.toStack(1));
                    if (extractedVariant.getItem().method_7858() != null) {
                        storage.insert((Object)ItemVariant.of((class_1799)remainder), (long)remainder.method_7947(), transaction);
                    }
                    it.remove();
                }
            }
        }
        return ingredients.isEmpty();
    }

    public static class Residual {
        public final class_1856 ingredient;
        public long residual;

        public Residual(class_1856 ingredient, int batchSize) {
            this.ingredient = ingredient;
            this.residual = batchSize;
        }
    }

    static class FabricatorLoopException
    extends Exception {
        FabricatorLoopException() {
        }
    }
}

