/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.neep.meatlib.client.flw.MeatModels;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.fabricator.FabricatorBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class FabricatorVisual
extends AbstractBlockEntityVisual<FabricatorBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance rotor;
    private final List<TransformedInstance> segments;
    private float speed;
    private float mainAngle;
    private final class_310 client = class_310.method_1551();

    public FabricatorVisual(VisualizationContext ctx, FabricatorBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        this.rotor = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.FABRICATOR_ROTOR, true)).createInstance();
        this.segments = IntStream.range(0, 8).mapToObj(i -> (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MeatModels.solid(NMExtraModels.FABRICATOR_SEGMENT, true)).createInstance()).toList();
    }

    public void _delete() {
        this.rotor.delete();
        for (TransformedInstance segment : this.segments) {
            segment.delete();
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        boolean paused = this.client.method_1493();
        this.speed = class_3532.method_16439((float)(paused ? 0.0f : 0.1f), (float)this.speed, (float)(((FabricatorBlockEntity)this.blockEntity).animation ? 10.0f : 0.0f));
        if (((FabricatorBlockEntity)this.blockEntity).animation) {
            ((FabricatorBlockEntity)this.blockEntity).animation = false;
        }
        float oldMainAngle = this.mainAngle;
        this.mainAngle += paused ? 0.0f : this.client.method_1534() * this.speed;
        boolean changed = this.mainAngle != oldMainAngle;
        ((TransformedInstance)this.rotor.setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, 1.0f, 0.0f).rotateCentered(this.mainAngle, (Vector3fc)class_2350.field_11036.method_23955());
        for (int i = 0; i < this.segments.size(); ++i) {
            float angle = (float)Math.PI / 180 * ((float)i / 8.0f * 360.0f % 360.0f) + this.mainAngle;
            float yOffset = 0.1f * class_3532.method_15374((float)(this.mainAngle * ((float)i - 8.0f * class_3532.method_15374((float)(this.mainAngle / 100.0f)) - 4.0f)));
            TransformedInstance segment = this.segments.get(i);
            ((TransformedInstance)segment.setIdentityTransform().translate((class_2382)this.getVisualPosition())).translate(0.0f, 1.0f - yOffset, 0.0f).rotateCentered(angle, (Vector3fc)class_2350.field_11036.method_23955());
            if (!changed) continue;
            segment.setChanged();
        }
        if (changed) {
            this.rotor.setChanged();
        }
    }

    public void updateLight(float v) {
        this.relight(this.pos, this.segments.iterator());
        this.relight(this.pos, new FlatLit[]{this.rotor});
    }

    public static void initNetwork() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricatorBlockEntity.CHANNEL_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            client.execute(() -> {
                class_2586 patt5094$temp = client.field_1687.method_8321(pos);
                if (patt5094$temp instanceof FabricatorBlockEntity) {
                    FabricatorBlockEntity fabricator = (FabricatorBlockEntity)patt5094$temp;
                    fabricator.animation = true;
                }
            });
        });
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

