/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.ChannelManager;
import com.neep.neepmeat.init.NMScreenHandlers;
import com.neep.neepmeat.machine.fabricator.FabricatorBlockEntity;
import com.neep.neepmeat.screen_handler.BasicScreenHandler;
import com.neep.neepmeat.screen_handler.slot.PatternSlot;
import com.neep.neepmeat.transport.block.item_transport.entity.PersistentCraftingInventory;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class FabricatorScreenHandler
extends BasicScreenHandler {
    private boolean sync = true;
    private final class_1263 inputInventory;
    private final FabricatorBlockEntity be;
    public final ChannelManager<SyncRecipe> syncRecipe;
    public final ChannelManager<Consumer<class_2960>> fillRecipe;
    public final ChannelManager<BooleanConsumer> useExternal;
    public final List<class_1735> patternSlots;
    public final List<class_1735> inputSlots;
    public final List<class_1735> playerSlots;
    private class_1799 prevBufferedStack = class_1799.field_8037;

    public FabricatorScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(inventory, new PersistentCraftingInventory.Simple(9), (class_1263)new class_1277(18), syncId, (FabricatorBlockEntity)inventory.field_7546.method_37908().method_8321(buf.method_10811()));
    }

    public FabricatorScreenHandler(class_1661 playerInventory, class_8566 recipeInventory, class_1263 inputInventory, int syncId, FabricatorBlockEntity be) {
        super(NMScreenHandlers.FABRICATOR, playerInventory, inputInventory, syncId, null);
        this.inputInventory = inputInventory;
        this.be = be;
        this.inputSlots = this.createSlotBlock(0, 18, 9, 2, inputInventory, 0, class_1735::new);
        this.playerSlots = this.createPlayerSlots(8, 99, playerInventory);
        this.patternSlots = this.createSlotBlock(19, 19, 3, 3, (class_1263)recipeInventory, 0, PatternSlot::new);
        this.syncRecipe = this.addClosable(ChannelManager.create(class_2960.method_43902((String)"neepmeat", (String)"fabricator/sync_recipe"), ChannelFormat.builder(SyncRecipe.class).param(ParamCodec.ofNullable(ParamCodecs.IDENTIFIER)).param(ParamCodecs.ITEM_STACK).param(ParamCodec.BOOLEAN).build(), playerInventory.field_7546));
        this.fillRecipe = this.addClosable(ChannelManager.create(class_2960.method_43902((String)"neepmeat", (String)"fabricator/fill_recipe"), ChannelFormat.builder(ParamCodecs.as(Consumer.class)).param(ParamCodecs.IDENTIFIER).build(), playerInventory.field_7546));
        this.useExternal = this.addClosable(ChannelManager.create(class_2960.method_43902((String)"neepmeat", (String)"fabricator/use_external"), ChannelFormat.BOOLEAN, playerInventory.field_7546));
        class_1657 class_16572 = playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_16572;
            this.fillRecipe.receiver(this::receiveFill);
            this.useExternal.receiver(this::recieveUseExternal);
        }
    }

    private void recieveUseExternal(boolean useExternal) {
        this.be.setUseExternal(useExternal);
        this.sync = true;
    }

    void receiveFill(class_2960 id) {
        Object var3_2 = this.be.method_10997().method_8433().method_8130(id).orElse(null);
        if (var3_2 instanceof class_3955) {
            class_3955 craftingRecipe = var3_2;
            this.fillRecipe(craftingRecipe);
        }
        this.sync = true;
    }

    void fillRecipe(class_3955 recipe) {
        class_2371 ingredients = recipe.method_8117();
        for (class_1735 patternSlot : this.patternSlots) {
            patternSlot.method_48931(class_1799.field_8037);
        }
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            int height = shapedRecipe.method_8158();
            int width = shapedRecipe.method_8150();
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    class_1856 ingredient;
                    int slotIdx = j * 3 + i;
                    int idx = j * width + i;
                    if (idx >= ingredients.size() || (ingredient = (class_1856)ingredients.get(idx)).method_8103()) continue;
                    this.patternSlots.get(slotIdx).method_48931(this.firstValidMatchingStack(ingredient));
                }
            }
        } else {
            int slotIdx = 0;
            for (class_1856 ingredient : ingredients) {
                class_1735 slot = this.patternSlots.get(slotIdx);
                if (!ingredient.method_8103()) {
                    slot.method_48931(ingredient.method_8105()[0]);
                }
                ++slotIdx;
            }
        }
    }

    private class_1799 firstValidMatchingStack(class_1856 ingredient) {
        return ingredient.method_8105()[0].method_7972();
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.ready && this.sync || !this.be.getStorage().getBufferedStack().equals(this.prevBufferedStack)) {
            class_3955 recipe;
            this.syncRecipe.emitter().apply((recipe = this.be.getCurrentRecipe()) != null ? recipe.method_8114() : null, this.be.getStorage().getBufferedStack(), this.be.useExternal);
            this.prevBufferedStack = this.be.getStorage().getBufferedStack().method_7972();
            this.sync = false;
        }
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        super.method_7593(slotIndex, button, actionType, player);
        this.sync = true;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        if (this.patternSlots.contains(this.field_7761.get(index))) {
            return class_1799.field_8037;
        }
        return super.method_7601(player, index);
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        if (endIndex > this.patternSlots.get((int)0).field_7874) {
            endIndex = this.patternSlots.get((int)0).field_7874;
        }
        return super.method_7616(stack, startIndex, endIndex, fromLast);
    }

    public static interface SyncRecipe {
        public void apply(@Nullable class_2960 var1, class_1799 var2, boolean var3);
    }
}

