/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Either;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.inventory.ImplementedInventory;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.machine.fabricator.FabricatorBlock;
import com.neep.neepmeat.machine.fabricator.FabricatorScreenHandler;
import com.neep.neepmeat.machine.fabricator.RecipeMatching;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.item_network.PipeCacheImpl;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class FabricatorBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
ExtendedScreenHandlerFactory,
RoutablePipe {
    public static final class_2960 CHANNEL_ID = new class_2960("fabricator_animation");
    private final ObjectArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>> caches = new ObjectArrayList(Collections.nCopies(6, null));
    private final FabricatorInventory inventory = new FabricatorInventory();
    private final ImplementedInventory inputInventory = ImplementedInventory.ofSize(18, this::method_5431);
    private final InventoryStorage inputStorage = InventoryStorage.of((class_1263)this.inputInventory, null);
    private final FabricatorStorage storage = new FabricatorStorage();
    public boolean useExternal;
    private float increment;
    private float progress;
    public boolean animation;

    public FabricatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.progress = Math.min(5.0f, this.progress + this.increment);
        if (this.progress >= 5.0f) {
            this.progress = 0.0f;
            try {
                this.motorCraft();
            }
            catch (RecipeMatching.FabricatorLoopException fabricatorLoopException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void setInputPower(float power) {
        this.increment = power;
    }

    private void motorCraft() throws RecipeMatching.FabricatorLoopException {
        class_3955 recipe = this.getCurrentRecipe();
        if (recipe != null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
            List<Storage<ItemVariant>> input = this.getInput(facing);
            ArrayList<class_1856> ingredients = new ArrayList<class_1856>((Collection<class_1856>)recipe.method_8117());
            ArrayList<ItemVariant> takenResources = new ArrayList<ItemVariant>();
            try (Transaction transaction = Transaction.openOuter();){
                boolean foundAll = RecipeMatching.findMatching(input, ingredients, takenResources, (TransactionContext)transaction);
                if (!foundAll) {
                    transaction.abort();
                    return;
                }
                class_1799 result = recipe.method_8110(this.field_11863.method_30349());
                long ejected = ItemPipeUtil.EjectOperation.of(this.field_11863, this.field_11867, facing).useRouting(true).stackToAny(ItemVariant.of((class_1799)result), result.method_7947(), (TransactionContext)transaction).amount();
                if (ejected != (long)result.method_7947()) {
                    transaction.abort();
                    return;
                }
                this.sendAnimation();
                transaction.commit();
            }
        }
    }

    private Either<Collection<RecipeMatching.Residual>, class_1799> craft(int batchSize, TransactionContext transaction) throws RecipeMatching.FabricatorLoopException {
        class_3955 recipe = this.getCurrentRecipe();
        if (recipe != null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
            List<Storage<ItemVariant>> input = this.getInput(facing);
            try (Transaction inner = transaction.openNested();){
                Collection<RecipeMatching.Residual> residuals = RecipeMatching.findMatchingWithResiduals(batchSize, input, (List<class_1856>)recipe.method_8117(), (TransactionContext)inner);
                if (!residuals.isEmpty()) {
                    inner.abort();
                    Either either = Either.left(residuals);
                    return either;
                }
                class_1799 result = recipe.method_8110(this.field_11863.method_30349()).method_7972();
                result.method_7939(batchSize * result.method_7947());
                transaction.addCloseCallback((t, r) -> {
                    if (r.wasCommitted()) {
                        this.sendAnimation();
                    }
                });
                inner.commit();
                Either either = Either.right((Object)result);
                return either;
            }
        }
        return Either.left(List.of());
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.inventory.writeNbt(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10566("input", (class_2520)this.inputInventory.writeNbt(new class_2487()));
        nbt.method_10556("use_external", this.useExternal);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory.readNbt(nbt);
        this.storage.readNbt(nbt);
        this.inputInventory.readNbt(nbt.method_10562("input"));
        this.useExternal = !nbt.method_10545("use_external") ? true : nbt.method_10577("use_external");
    }

    private List<Storage<ItemVariant>> getInput(class_2350 facing) {
        if (!this.useExternal) {
            return List.of(this.inputStorage);
        }
        ArrayList<Storage<ItemVariant>> storages = new ArrayList<Storage<ItemVariant>>();
        storages.add((Storage<ItemVariant>)this.inputStorage);
        for (class_2350 direction : class_2350.values()) {
            Storage<ItemVariant> storage;
            if (direction != facing.method_10153() && direction != facing.method_10170() && direction != facing.method_10160() || (storage = this.findStorage(direction)) == null) continue;
            storages.add(storage);
        }
        return storages;
    }

    @Nullable
    private Storage<ItemVariant> findStorage(class_2350 face) {
        if (this.caches.get(face.ordinal()) == null) {
            this.caches.set(face.ordinal(), (Object)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(face)));
        }
        return (Storage)((BlockApiCache)this.caches.get(face.ordinal())).find((Object)face.method_10153());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FabricatorScreenHandler(playerInventory, this.inventory, (class_1263)this.inputInventory, syncId, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    @Nullable
    public class_3955 getCurrentRecipe() {
        return this.storage.getRecipe();
    }

    public Storage<ItemVariant> getStorage(class_2350 direction) {
        return direction == this.method_11010().method_11654((class_2769)FabricatorBlock.FACING) || direction == class_2350.field_11033 ? this.storage : this.inputStorage;
    }

    public void sendAnimation() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PlayerLookup.tracking((class_2586)this).forEach(p -> {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(this.method_11016());
                ServerPlayNetworking.send((class_3222)p, (class_2960)CHANNEL_ID, (class_2540)buf);
            });
        }
    }

    @Nullable
    private Pair<class_2338, class_2350> findRequestPos(class_2350 exclude) {
        class_2338.class_2339 mutable = this.field_11867.method_25503();
        for (class_2350 face : class_2350.class_2353.field_11062) {
            if (face == exclude) continue;
            mutable.method_25505((class_2382)this.field_11867, face);
            class_2680 state = this.field_11863.method_8320((class_2338)mutable);
            ConnectablePipe pipe = ItemPipe.findItemPipe(this.field_11863, (class_2338)mutable, state);
            if (pipe == null || !pipe.isConnected((class_1922)this.field_11863, (class_2338)mutable, state, face.method_10153())) continue;
            return Pair.of((Object)mutable, (Object)face.method_10153());
        }
        return null;
    }

    @Override
    public RoutablePipe.Result request(Predicate<ItemVariant> predicate, long maxAmount, NodePos fromPos, RoutingNetwork.RequestContext context, TransactionContext transaction) {
        this.storage.load();
        if (!predicate.test(ItemVariant.of((class_1799)this.storage.previewStack))) {
            if (!this.storage.bufferedStack.method_7960() && !this.storage.previewStack.method_31574(this.storage.bufferedStack.method_7909())) {
                MeatlibStorageUtil.scatterAmount(this.field_11863, this.field_11867, (ResourceAmount<ItemVariant>)new ResourceAmount((Object)ItemVariant.of((class_1799)this.storage.bufferedStack), (long)this.storage.bufferedStack.method_7947()));
                this.storage.bufferedStack = class_1799.field_8037;
            }
            return RoutablePipe.Result.FAIL;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
        RoutablePipe.IngredientResult result = this.storage.request(predicate, true, maxAmount, transaction);
        PipeCacheImpl itemNetwork = ((IServerWorld)this.field_11863).getItemNetwork();
        long immediateRouted = 0L;
        if (result.amount() > 0L) {
            ItemVariant extractable = ItemVariant.of((class_1799)this.storage.previewStack);
            ItemRoute route = itemNetwork.findPath((ResourceAmount<ItemVariant>)new ResourceAmount((Object)extractable, result.amount()), this.field_11867.method_10093(facing), fromPos.pos(), fromPos.face());
            immediateRouted = itemNetwork.route(this.field_11867, facing, route, extractable, result.amount(), transaction);
        }
        if (result.deferredAmount() > 0L || !result.residuals.isEmpty()) {
            ItemPipeBlockEntity ipbe;
            RoutingNetwork network;
            Pair<class_2338, class_2350> requestPos = this.findRequestPos(facing);
            if (requestPos == null) {
                return RoutablePipe.Result.FAIL;
            }
            class_2586 class_25862 = this.field_11863.method_8321((class_2338)requestPos.first());
            if (class_25862 instanceof ItemPipeBlockEntity && (network = (ipbe = (ItemPipeBlockEntity)class_25862).getCache().getNetwork()) != null) {
                for (RecipeMatching.Residual residual : result.residuals) {
                    if (network.request(v -> residual.ingredient.method_8093(v.toStack()), residual.residual, (class_2338)requestPos.first(), (class_2350)requestPos.second(), RoutingNetwork.RequestType.EXACT_AMOUNT, context, transaction)) continue;
                    return RoutablePipe.Result.FAIL;
                }
            }
        }
        return new RoutablePipe.Result(immediateRouted, result.deferredAmount(), result.deferredResult());
    }

    @Override
    public RoutablePipe.DeferredResult deferredUpdate(RoutingNetwork.DeferredRequest request, RoutingNetwork network, TransactionContext transaction) {
        this.storage.load();
        if (!request.getItemVariant().matches(this.storage.previewStack)) {
            return RoutablePipe.DeferredResult.FAIL;
        }
        try {
            Either<Collection<RecipeMatching.Residual>, class_1799> craftResult = this.craft((int)Math.ceil((double)request.getRequested() / (double)this.storage.previewStack.method_7947()), transaction);
            if (craftResult.right().isPresent()) {
                this.storage.appendBuffered((class_1799)craftResult.right().get());
                ItemVariant extractable = ItemVariant.of((class_1799)this.storage.bufferedStack);
                if (extractable.isBlank()) {
                    return RoutablePipe.DeferredResult.FAIL;
                }
                long amount = request.getRequested();
                this.storage.bufferedStack.method_7934((int)request.getRequested());
                PipeCacheImpl itemNetwork = ((IServerWorld)this.field_11863).getItemNetwork();
                class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FabricatorBlock.FACING);
                ItemRoute route = itemNetwork.findPath((ResourceAmount<ItemVariant>)new ResourceAmount((Object)extractable, amount), this.field_11867.method_10093(facing), request.requesterPos, request.requesterFace);
                long routed = itemNetwork.route(this.field_11867, facing, route, extractable, amount, transaction);
                if (routed < amount) {
                    MeatlibStorageUtil.scatterAmount(this.field_11863, this.field_11867, (ResourceAmount<ItemVariant>)new ResourceAmount((Object)extractable, amount - routed));
                }
                return RoutablePipe.DeferredResult.SUCCESS;
            }
            return RoutablePipe.DeferredResult.PASS;
        }
        catch (RecipeMatching.FabricatorLoopException e) {
            return RoutablePipe.DeferredResult.FAIL;
        }
    }

    @Override
    public Stream<StorageView<ItemVariant>> getAvailable(TransactionContext transaction) {
        return Streams.stream((Iterable)((Object)this.storage));
    }

    @Override
    public class_2338 getRoutablePipePos() {
        return this.field_11867;
    }

    public FabricatorStorage getStorage() {
        return this.storage;
    }

    public void setUseExternal(boolean useExternal) {
        this.useExternal = useExternal;
        this.method_5431();
    }

    public Storage<ItemVariant> getInputStorage() {
        return this.inputStorage;
    }

    public class FabricatorInventory
    implements ImplementedInventory,
    class_8566 {
        private final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);

        @Override
        public class_2371<class_1799> getItems() {
            return this.items;
        }

        @Override
        public void method_5431() {
            FabricatorBlockEntity.this.storage.invalidateRecipe();
            FabricatorBlockEntity.this.method_5431();
        }

        public int method_17398() {
            return 3;
        }

        public int method_17397() {
            return 3;
        }

        public List<class_1799> method_51305() {
            return this.items;
        }

        public void method_7683(class_1662 finder) {
            for (class_1799 itemStack : this.items) {
                finder.method_7404(itemStack);
            }
        }
    }

    public class FabricatorStorage
    extends SnapshotParticipant<class_1799>
    implements Storage<ItemVariant>,
    StorageView<ItemVariant>,
    NbtSerialisable {
        private boolean needsLoading = true;
        @Nullable
        private class_3955 recipe;
        private class_1799 bufferedStack = class_1799.field_8037;
        private class_1799 previewStack = class_1799.field_8037;

        private void updateRecipe() {
            this.recipe = FabricatorBlockEntity.this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)FabricatorBlockEntity.this.inventory, FabricatorBlockEntity.this.field_11863).orElse(null);
            if (this.recipe != null) {
                this.previewStack = this.recipe.method_8110(FabricatorBlockEntity.this.field_11863.method_30349()).method_7972();
            }
        }

        @Nullable
        public class_3955 getRecipe() {
            this.load();
            return this.recipe;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.bufferedStack.method_7960() && resource.matches(this.bufferedStack) || resource.matches(this.previewStack)) {
                return this.extractOrCraft(maxAmount, false, transaction).total();
            }
            return 0L;
        }

        public RoutablePipe.IngredientResult request(Predicate<ItemVariant> predicate, boolean recursive, long maxAmount, TransactionContext transaction) {
            if (!this.bufferedStack.method_7960() && predicate.test(ItemVariant.of((class_1799)this.bufferedStack)) || predicate.test(ItemVariant.of((class_1799)this.previewStack))) {
                return this.extractOrCraft(maxAmount, recursive, transaction);
            }
            return RoutablePipe.IngredientResult.FAIL;
        }

        private RoutablePipe.IngredientResult extractOrCraft(long maxAmount, boolean recursive, TransactionContext transaction) {
            long requiredExtra = maxAmount - (long)this.bufferedStack.method_7947();
            if (!this.bufferedStack.method_7960() && requiredExtra <= 0L) {
                int amountToExtract = (int)Math.min((long)this.bufferedStack.method_7947(), maxAmount);
                if (amountToExtract > 0) {
                    this.updateSnapshots(transaction);
                    this.bufferedStack.method_7934(amountToExtract);
                    ItemVariant resultVariant = ItemVariant.of((class_1799)this.bufferedStack);
                    return RoutablePipe.IngredientResult.immediate(amountToExtract);
                }
            } else if (requiredExtra > 0L) {
                this.updateSnapshots(transaction);
                int remainingCapacity = this.previewStack.method_7914() - this.bufferedStack.method_7947();
                int maxBatchSize = Math.min(remainingCapacity / this.previewStack.method_7947(), 64);
                int desiredBatchSize = (int)Math.ceil((double)requiredExtra / (double)this.previewStack.method_7947());
                int batchSize = Math.min(maxBatchSize, desiredBatchSize);
                try {
                    Either<Collection<RecipeMatching.Residual>, class_1799> result = FabricatorBlockEntity.this.craft(batchSize, transaction);
                    if (result.right().isPresent()) {
                        class_1799 newStack = (class_1799)result.right().get();
                        this.appendBuffered(newStack);
                    } else {
                        if (result.left().isPresent() && recursive) {
                            ItemVariant resultVariant = ItemVariant.of((class_1799)this.previewStack);
                            int immediate = this.bufferedStack.method_7947();
                            this.bufferedStack.method_7934(immediate);
                            return new RoutablePipe.IngredientResult(immediate, requiredExtra, resultVariant, (Collection)result.left().get());
                        }
                        if (batchSize > 1 && this.bufferedStack.method_7960()) {
                            this.bufferedStack = FabricatorBlockEntity.this.craft(1, transaction).right().orElse(class_1799.field_8037);
                        }
                    }
                }
                catch (RecipeMatching.FabricatorLoopException ignored) {
                    return RoutablePipe.IngredientResult.FAIL;
                }
                int extractable = (int)Math.min((long)this.bufferedStack.method_7947(), maxAmount);
                if (extractable > 0) {
                    ItemVariant resultVariant = ItemVariant.of((class_1799)this.bufferedStack);
                    this.bufferedStack.method_7934(extractable);
                    return RoutablePipe.IngredientResult.immediate(extractable);
                }
            }
            return RoutablePipe.IngredientResult.FAIL;
        }

        public void appendBuffered(class_1799 newBuffered) {
            if (!this.bufferedStack.method_7960() && class_1799.method_31577((class_1799)this.bufferedStack, (class_1799)newBuffered)) {
                this.bufferedStack.method_7933(newBuffered.method_7947());
            } else {
                this.bufferedStack = newBuffered;
            }
        }

        public boolean supportsInsertion() {
            return false;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean isResourceBlank() {
            this.load();
            return this.bufferedStack.method_7960() && this.previewStack.method_7960();
        }

        public ItemVariant getResource() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return ItemVariant.of((class_1799)this.bufferedStack);
            }
            return ItemVariant.of((class_1799)this.previewStack);
        }

        public long getAmount() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return this.bufferedStack.method_7947();
            }
            return this.previewStack.method_7947();
        }

        public long getCapacity() {
            this.load();
            if (!this.bufferedStack.method_7960()) {
                return this.bufferedStack.method_7947();
            }
            return this.previewStack.method_7947();
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            this.load();
            return Iterators.singletonIterator((Object)this);
        }

        private void load() {
            if (this.needsLoading) {
                this.needsLoading = false;
                this.updateRecipe();
            }
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
            nbt.method_10566("buffered", (class_2520)this.bufferedStack.method_7953(new class_2487()));
            return nbt;
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.recipe = nbt.method_10545("recipe") ? (class_3955)MeatlibRecipes.getInstance().getVanilla(class_3956.field_17545, class_2960.method_12829((String)nbt.method_10558("recipe"))).orElse(null) : null;
            this.bufferedStack = class_1799.method_7915((class_2487)nbt.method_10562("buffered"));
        }

        protected class_1799 createSnapshot() {
            return this.bufferedStack.method_7972();
        }

        protected void readSnapshot(class_1799 snapshot) {
            this.bufferedStack = snapshot.method_7972();
        }

        protected void onFinalCommit() {
            FabricatorBlockEntity.this.method_5431();
        }

        public void invalidateRecipe() {
            this.needsLoading = true;
        }

        public class_1799 getBufferedStack() {
            return this.bufferedStack;
        }
    }
}

