/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.crucible;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.machine.crucible.CrucibleBlockEntity;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class CrucibleStorageImpl
implements CrucibleStorage,
NbtSerialisable {
    protected CrucibleBlockEntity parent;
    protected WritableSingleFluidStorage fluidStorage;
    protected SingleVariantStorage<ItemVariant> itemStorage;

    public CrucibleStorageImpl(final CrucibleBlockEntity parent) {
        this.parent = parent;
        this.fluidStorage = new WritableSingleFluidStorage(81000L, parent::sync);
        this.itemStorage = new WritableStackStorage(parent::sync, 3){

            public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
                if (insertedVariant.isBlank() || maxAmount == 0L) {
                    return 0L;
                }
                long processed = 0L;
                try (Transaction inner = transaction.openNested();){
                    long inserted = super.insert((TransferVariant)insertedVariant, maxAmount, (TransactionContext)inner);
                    if (inserted > 0L) {
                        processed = parent.processItem(inserted, (TransactionContext)inner);
                    }
                    if (processed > 0L) {
                        inner.commit();
                    } else {
                        inner.abort();
                    }
                }
                return processed;
            }

            @Override
            protected ItemVariant getBlankVariant() {
                return ItemVariant.blank();
            }
        };
    }

    public SingleSlotStorage<FluidVariant> getStorage(@Nullable class_2350 direction) {
        return this.fluidStorage;
    }

    public SingleSlotStorage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        return direction == class_2350.field_11036 || direction == null ? this.itemStorage : null;
    }

    @Override
    public Storage<FluidVariant> getFluidOutput() {
        return this.parent.getOutput();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        this.fluidStorage.toNbt(nbt);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.fluidStorage.readNbt(nbt);
    }
}

