/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.crucible;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.AlembicBlockEntity;
import com.neep.neepmeat.machine.crucible.CrucibleStorageImpl;
import com.neep.neepmeat.machine.crucible.FatCollectorBlock;
import com.neep.neepmeat.recipe.RenderingBasinRecipe;
import java.util.ArrayList;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class CrucibleBlockEntity
extends SyncableBlockEntity {
    protected CrucibleStorageImpl storage = new CrucibleStorageImpl(this);

    public CrucibleBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public CrucibleBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.CRUCIBLE, pos, state);
    }

    public CrucibleStorageImpl getStorage() {
        return this.storage;
    }

    public CombinedStorage<FluidVariant, SingleVariantStorage<FluidVariant>> getOutput() {
        ArrayList<WritableSingleFluidStorage> storages = new ArrayList<WritableSingleFluidStorage>();
        for (class_2350 direction : class_2350.values()) {
            AlembicBlockEntity be;
            class_2338 offset;
            class_2586 class_25862;
            if (direction.method_10166().equals((Object)class_2350.class_2351.field_11052) || !((class_25862 = this.field_11863.method_8321(offset = this.field_11867.method_10093(direction))) instanceof AlembicBlockEntity) || (be = (AlembicBlockEntity)class_25862).method_11010().method_11654((class_2769)FatCollectorBlock.field_11177) != direction) continue;
            storages.add(be.getStorage(null));
        }
        return new CombinedStorage(storages);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
    }

    public void receiveItemEntity(class_1542 entity) {
        class_1799 stack = entity.method_6983();
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        try (Transaction transaction = Transaction.openOuter();){
            long decrement = this.storage.itemStorage.insert((TransferVariant)variant, (long)stack.method_7947(), (TransactionContext)transaction);
            stack.method_7934((int)decrement);
            transaction.commit();
        }
    }

    public long processItem(long maxAmount, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            ItemVariant processItem;
            RenderingBasinRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.RENDERING, this.storage).orElse(null);
            if (recipe == null) {
                recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ORE_FAT_RENDERING, this.storage).orElse(null);
            }
            if (recipe != null && (processItem = recipe.takeInputs(this.storage, (int)maxAmount, (TransactionContext)inner)) != null) {
                inner.commit();
                transaction.addCloseCallback((t, r) -> MeatlibStorageUtil.closeCallback(t, r, () -> CrucibleBlockEntity.spawnParticles((class_3218)this.field_11863, this.field_11867, processItem, 20)));
                long l = maxAmount;
                return l;
            }
            inner.abort();
        }
        return 0L;
    }

    public static void spawnParticles(class_3218 world, class_2338 pos, ItemVariant item, int amount) {
        double k;
        double j;
        double i;
        int p;
        class_1799 stack = item.toStack();
        Random random = new Random();
        for (p = 0; p < amount; ++p) {
            i = random.nextGaussian(0.5, 0.2);
            j = random.nextFloat();
            k = random.nextGaussian(0.5, 0.2);
            world.method_14199((class_2394)new class_2392(NMParticles.COLOURED_ITEM, stack), (double)pos.method_10263() + i, (double)(pos.method_10264() + 1), (double)pos.method_10260() + k, 1, 0.0, 0.2, 0.0, 0.02);
        }
        for (p = 0; p < amount; ++p) {
            i = random.nextGaussian(0.5, 0.2);
            j = random.nextFloat();
            k = random.nextGaussian(0.5, 0.2);
            world.method_14199((class_2394)class_2398.field_11202, (double)pos.method_10263() + i, (double)(pos.method_10264() + 1), (double)pos.method_10260() + k, 1, 0.0, 0.2, 0.0, 0.02);
        }
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14737, class_3419.field_15251, 1.0f, 0.8f);
    }
}

