/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.charnel_pump;

import com.neep.meatlib.util.ClientComponent;
import com.neep.neepmeat.client.sound.BlockSoundInstance;
import com.neep.neepmeat.client.sound.LoopingSoundInstance;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpBlockEntity;
import com.neep.neepmeat.machine.live_machine.process.CharnelPumpProcess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class CharnelPumpClient
implements ClientComponent {
    private final CharnelPumpBlockEntity be;
    private final class_1144 soundManager;
    private final class_1113 upSound;
    private final class_1113 topSound;
    private final class_1113 downSound;
    private final class_1113 glugSound;
    private final class_1113 idleSound;

    public CharnelPumpClient(CharnelPumpBlockEntity be) {
        this.be = be;
        this.soundManager = class_310.method_1551().method_1483();
        this.upSound = new BlockSoundInstance(NMSounds.CHARNEL_PUMP_UP, class_3419.field_15245, be.method_11016().method_10086(3));
        this.topSound = new BlockSoundInstance(NMSounds.CHARNEL_PUMP_TOP, class_3419.field_15245, be.method_11016().method_10086(3));
        this.downSound = new BlockSoundInstance(NMSounds.CHARNEL_PUMP_DOWN, class_3419.field_15245, be.method_11016().method_10086(3));
        this.glugSound = new BlockSoundInstance(NMSounds.CHARNEL_PUMP_GLUG, class_3419.field_15245, be.method_11016().method_10086(3));
        this.idleSound = new LoopingSoundInstance(NMSounds.CHARNEL_PUMP_IDLE, class_3419.field_15245, 1.0f, 1.0f, class_5819.method_43047(), be.method_11016().method_10086(3));
    }

    @Override
    public void clientTick() {
        float increment = this.be.progressIncrement();
        if (this.be.method_10997().method_8510() % 4L == 0L) {
            if (this.be.hasAir && !CharnelPumpProcess.canRun(increment, this.be)) {
                if (!this.soundManager.method_4877(this.idleSound)) {
                    this.soundManager.method_4873(this.idleSound);
                }
            } else {
                this.soundManager.method_4870(this.idleSound);
            }
        }
        if (CharnelPumpClient.matches(this.be.animationTicks, 100, increment)) {
            this.soundManager.method_4870(this.glugSound);
            this.soundManager.method_4870(this.upSound);
        } else if (CharnelPumpClient.matches(this.be.animationTicks, 99, increment)) {
            this.soundManager.method_4873(this.upSound);
        } else if (CharnelPumpClient.matches(this.be.animationTicks, 45, increment)) {
            this.soundManager.method_4873(this.topSound);
        } else if (CharnelPumpClient.matches(this.be.animationTicks, 40, increment)) {
            this.soundManager.method_4870(this.upSound);
            this.soundManager.method_4873(this.be.hasFluidCurrentCycle ? this.glugSound : this.downSound);
        }
    }

    private static boolean matches(float ticks, int value, float increment) {
        return Math.round(ticks) == value && Math.abs(ticks - (float)value) < Math.min(1.0f, increment);
    }
}

