/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.charnel_pump;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.ClientComponents;
import com.neep.meatlib.util.LazySupplier;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.enlightenment.EnlightenmentUtil;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.component.ChunkEnlightenmentComponent;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.machine.charnel_pump.WrithingEarthSpoutBlockEntity;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.component.PoweredComponent;
import com.neep.neepmeat.machine.live_machine.process.CharnelPumpProcess;
import com.neep.neepmeat.machine.well_head.BlockEntityFinder;
import com.neep.neepmeat.machine.well_head.WellHeadBlockEntity;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5819;

public class CharnelPumpBlockEntity
extends SyncableBlockEntity
implements LivingMachineComponent,
PoweredComponent {
    private final class_5819 random = class_5819.method_43047();
    private final LazySupplier<BlockEntityFinder<WellHeadBlockEntity>> wellHeadFinder = LazySupplier.of(() -> new BlockEntityFinder<WellHeadBlockEntity>(this.method_10997(), NMBlockEntities.WELL_HEAD, 20).addAll(BlockEntityFinder.chunkRange(this.method_11016())));
    private final LazySupplier<BlockEntityFinder<WrithingEarthSpoutBlockEntity>> writhingSpoutFinder = LazySupplier.of(() -> new BlockEntityFinder<WrithingEarthSpoutBlockEntity>(this.method_10997(), NMBlockEntities.WRITHING_EARTH_SPOUT, 20).addAll(BlockEntityFinder.chunkRange(this.method_11016())));
    private final ClientComponents.Holder<?> holder = new ClientComponents.BlockEntityHolder<CharnelPumpBlockEntity>(this);
    public float animationTicks;
    private float progressIncrement;
    public boolean hasAir;
    private boolean hasFluid;
    public boolean hasFluidCurrentCycle;
    private float progress;

    public CharnelPumpBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void serverTick(double puPower, Storage<FluidVariant> inputStorage, Transaction transaction) {
        this.wellHeadFinder.get().tick();
        this.writhingSpoutFinder.get().tick();
        Set<WellHeadBlockEntity> found = this.wellHeadFinder.get().result();
        boolean hasAir = false;
        try (Transaction inner = transaction.openNested();){
            long droplets = Math.max(10L, (long)(puPower * (double)((Integer)NeepMeat.CONFIG.charnelPump.powerToAir.getRealValue()).intValue()));
            long extracted = inputStorage.extract((Object)NMFluids.COMPRESSED_AIR.variant(), droplets, (TransactionContext)inner);
            if (extracted == droplets) {
                hasAir = true;
                inner.commit();
            }
        }
        if (this.hasAir != hasAir) {
            this.hasAir = hasAir;
            this.sync();
        }
        if (CharnelPumpProcess.canRun(puPower, this)) {
            boolean fluidAvailable;
            this.spawnSpouts();
            if (hasAir) {
                this.emitEnlightenment();
            }
            boolean bl = fluidAvailable = StorageUtil.simulateExtract(inputStorage, (Object)FluidVariant.of((class_3611)NMFluids.STILL_WORK_FLUID), (long)27000L, (TransactionContext)transaction) == 27000L;
            if (hasAir && fluidAvailable) {
                this.progress = (float)Math.max(0.0, (double)this.progress - puPower);
                if (this.progress <= 0.0f) {
                    this.progress = 100.0f;
                    for (WellHeadBlockEntity wellHead : found) {
                        try (Transaction inner = transaction.openNested();){
                            long extracted = inputStorage.extract((Object)FluidVariant.of((class_3611)NMFluids.STILL_WORK_FLUID), 27000L, (TransactionContext)inner);
                            if (extracted == 27000L) {
                                wellHead.receiveFluid(27000L, (TransactionContext)inner);
                                inner.commit();
                                continue;
                            }
                            inner.abort();
                        }
                    }
                }
            }
            if (this.hasFluid != fluidAvailable) {
                this.hasFluid = fluidAvailable;
                this.sync();
            }
        }
    }

    private boolean canSpoutSpawn(class_2338 surfacePos) {
        class_2680 surfaceState = this.field_11863.method_8320(surfacePos);
        return BlockEntityFinder.chunkRange(this.field_11867).contains(this.field_11863.method_22350(surfacePos).method_12004()) && surfaceState.method_26164(NMTags.WRITHING_EARTH_REPLACABLE);
    }

    private void spawnSpouts() {
        BlockEntityFinder<WrithingEarthSpoutBlockEntity> writhing;
        if (!this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(NMBlocks.WRITHING_STONE)) {
            this.field_11863.method_8652(this.field_11867.method_10074(), NMBlocks.WRITHING_STONE.method_9564(), 3);
        }
        if ((writhing = this.writhingSpoutFinder.get()).notDirty() && writhing.result().isEmpty()) {
            class_2338 rand = (class_2338)class_2338.method_34848((class_5819)this.random, (int)1, (class_2338)this.method_11016(), (int)25).iterator().next();
            class_2791 chunk = this.field_11863.method_22350(rand);
            class_2338 columnBottom = new class_2338(rand.method_10263(), this.field_11867.method_10264() - 10, rand.method_10260());
            class_2338 columnTop = new class_2338(rand.method_10263(), this.field_11867.method_10264() + 25, rand.method_10260());
            for (class_2338 blockPos : class_2338.method_10097((class_2338)columnBottom, (class_2338)columnTop)) {
                class_2338 surfacePos;
                class_2680 state = chunk.method_8320(blockPos);
                if (!state.method_26215() && state.method_26227().method_15769() || !this.canSpoutSpawn(surfacePos = blockPos.method_10074())) continue;
                this.field_11863.method_8652(surfacePos, NMBlocks.WRITHING_EARTH_SPOUT.method_9564(), 3);
                this.field_11863.method_8396(null, surfacePos, class_3417.field_29543, class_3419.field_15245, 1.0f, 1.0f);
                ((class_3218)this.field_11863).method_14199((class_2394)NMParticles.BODY_COMPOUND_SHOWER, (double)surfacePos.method_10263() + 0.5, (double)(surfacePos.method_10264() + 1), (double)surfacePos.method_10260() + 0.5, 50, 1.0, 10.0, 1.0, 0.1);
                return;
            }
        }
    }

    private void emitEnlightenment() {
        if (this.field_11863.method_8510() % 2L == 0L) {
            float enlightenment = 10.0f;
            class_243 centre = class_243.method_24953((class_2382)this.field_11867);
            this.method_10997().method_8390(class_1657.class, new class_238(this.field_11867).method_1009(16.0, 16.0, 16.0), p -> true).forEach(p -> EnlightenmentUtil.applyDose((class_3222)p, enlightenment, p.method_5707(centre), 0.02));
        }
        ChunkEnlightenmentComponent.distribute(this.field_11863, this.field_11867, 10.0, 1);
    }

    public boolean canRun() {
        return CharnelPumpProcess.canRun(this.progressIncrement, this);
    }

    @Override
    public void toClientTag(class_2487 nbt) {
        nbt.method_10548("power", this.progressIncrement);
        nbt.method_10556("has_air", this.hasAir);
        nbt.method_10556("has_fluid", this.hasFluid);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progressIncrement = nbt.method_10583("power");
        this.hasAir = nbt.method_10577("has_air");
        this.hasFluid = nbt.method_10577("has_fluid");
    }

    @Override
    public boolean componentRemoved() {
        return this.method_11015();
    }

    @Override
    public ComponentType<? extends LivingMachineComponent> getComponentType() {
        return LivingMachineComponents.CHARNEL_PUMP;
    }

    private void spawnAirParticles() {
        if (this.field_11863.method_8510() % 2L == 0L) {
            double x = (double)this.method_11016().method_10263() + 0.5;
            double y = this.method_11016().method_10264();
            double z = (double)this.method_11016().method_10260() + 0.5;
            this.field_11863.method_8406((class_2394)class_2398.field_11203, x + 1.0, y + 1.0, z + 1.0, 0.1, 0.1, 0.1);
            this.field_11863.method_8406((class_2394)class_2398.field_11203, x - 1.0, y + 1.0, z + 1.0, -0.1, 0.1, 0.1);
            this.field_11863.method_8406((class_2394)class_2398.field_11203, x + 1.0, y + 1.0, z - 1.0, 0.1, 0.1, -0.1);
            this.field_11863.method_8406((class_2394)class_2398.field_11203, x - 1.0, y + 1.0, z - 1.0, -0.1, 0.1, -0.1);
        }
    }

    private void clientTickAir() {
        if (this.hasAir) {
            if (!CharnelPumpProcess.canRun(this.progressIncrement, this)) {
                this.spawnAirParticles();
            } else if (this.animationTicks < 30.0f) {
                this.spawnAirParticles();
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, CharnelPumpBlockEntity be) {
        be.clientTickAir();
        if (be.progressIncrement > 0.0f && be.hasAir) {
            be.animationTicks = Math.max(0.0f, be.animationTicks - be.progressIncrement());
            if (be.animationTicks == 0.0f) {
                be.animationTicks = 100.0f;
                be.hasFluidCurrentCycle = be.hasFluid;
            }
        } else {
            be.animationTicks = Math.max(0.0f, be.animationTicks - 1.0f);
        }
        be.holder.get().clientTick();
    }

    @Override
    public float progressIncrement() {
        return this.progressIncrement;
    }

    @Override
    public void setProgressIncrement(float progressIncrement) {
        if (progressIncrement != this.progressIncrement) {
            this.progressIncrement = Math.min(1.9f, progressIncrement);
            this.sync();
        }
    }

    public static boolean isRising(float animationTicks) {
        return animationTicks < 60.0f;
    }
}

