/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.charnel_pump;

import com.google.common.collect.ImmutableMap;
import com.neep.meatlib.block.MeatlibBlock;
import com.neep.meatlib.block.MeatlibBlockSettings;
import com.neep.meatlib.item.BaseBlockItem;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.api.big_block.BigBlock;
import com.neep.neepmeat.api.big_block.BigBlockPattern;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.init.NMBlocks;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpBlockEntity;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpStructure;
import com.neep.neepmeat.machine.live_machine.LivingMachines;
import com.neep.neepmeat.util.MiscUtil;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CharnelPumpBlock
extends BigBlock<CharnelPumpStructure>
implements MeatlibBlock,
class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    private final Map<class_2350, BigBlockPattern> patternMap;

    public CharnelPumpBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, settings);
        ctx.append(this, new BaseBlockItem(this, ctx, itemSettings));
        BigBlockPattern volume = BigBlockPattern.makeOddCylinder(1, 0, 7, ((CharnelPumpStructure)this.getStructure()).method_9564());
        this.patternMap = ImmutableMap.of((Object)class_2350.field_11043, (Object)volume, (Object)class_2350.field_11034, (Object)volume.rotateY(90.0f), (Object)class_2350.field_11035, (Object)volume.rotateY(180.0f), (Object)class_2350.field_11039, (Object)volume.rotateY(270.0f));
    }

    @Override
    public class_265 getBreakParticleShape(class_1937 world, class_2338 pos, class_2680 state) {
        return this.getVolume(state).toVoxelShape();
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        CharnelPumpBlockEntity be;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CharnelPumpBlockEntity && (be = (CharnelPumpBlockEntity)class_25862).canRun()) {
            int range = 32;
            for (class_2338 randomPos : class_2338.method_34848((class_5819)random, (int)3, (class_2338)pos, (int)range)) {
                class_2680 prevState;
                int surface = world.method_22350(randomPos).method_12032(class_2902.class_2903.field_13202).method_12603(randomPos.method_10263() & 0xF, randomPos.method_10260() & 0xF) - 1;
                class_2338 surfacePos = new class_2338(randomPos.method_10263(), surface, randomPos.method_10260());
                float dx = randomPos.method_10263() - pos.method_10263();
                float dz = randomPos.method_10260() - pos.method_10260();
                float radius = Math.max(0.0f, (float)range - class_3532.method_15355((float)(dx * dx + dz * dz))) / (float)range;
                float prob = radius * radius;
                prob = Math.min(1.0f, prob * 2.0f);
                if (!(random.method_43057() < prob) || !(prevState = world.method_8320(surfacePos)).method_26164(NMTags.CONTAMINATED_RUBBLE_REPLACABLE)) continue;
                world.method_8501(surfacePos, NMBlocks.CONTAMINATED_DIRT.method_9564());
            }
        }
        super.method_9514(state, world, pos, random);
    }

    @Override
    protected CharnelPumpStructure registerStructureBlock(RegistrationContext ctx) {
        return ctx.append((Object)this, new CharnelPumpStructure(this, (class_4970.class_2251)MeatlibBlockSettings.copyOf((class_4970)this)), "charnel_pump_structure_1");
    }

    @Override
    public BigBlockPattern getVolume(class_2680 blockState) {
        return this.patternMap.get(blockState.method_11654((class_2769)FACING));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return LivingMachines.CHARNEL_PUMP_BE.method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MiscUtil.checkType(type, LivingMachines.CHARNEL_PUMP_BE, null, CharnelPumpBlockEntity::clientTick, world);
    }
}

