/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.bottler;

import com.neep.meatlib.block.BaseHorFacingBlock;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.block.entity.MotorisedMachineBlockEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.bottler.BottlerStorage;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.TransferApiImpl;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class BottlerBlockEntity
extends MotorisedMachineBlockEntity {
    private final BottlerStorage storage = new BottlerStorage(this);
    public static final int MAX_PROGRESS = 5;
    private float progress;
    private int maxProgress = 5;
    private long startTime;
    private State state = State.IDLE;
    private float powdder = 0.0f;

    public BottlerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 0.02f, 1.0f);
    }

    public BottlerBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.BOTTLER, pos, state);
    }

    public WritableStackStorage getItemStorage(class_2350 direction) {
        return this.storage.getItemStorage();
    }

    public Storage<FluidVariant> getStorage(class_2350 direction) {
        return this.storage.getFluidStorage();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10548("progress", this.progress);
        nbt.method_10569("maxProgress", this.maxProgress);
        nbt.method_10544("startTime", this.startTime);
        nbt.method_10569("state", this.state.ordinal());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.progress = nbt.method_10583("progress");
        this.maxProgress = nbt.method_10550("maxProgress");
        this.startTime = nbt.method_10537("startTime");
        this.state = State.values()[nbt.method_10550("state")];
    }

    private Storage<FluidVariant> getInputStorage() {
        return (Storage)FluidStorage.SIDED.find(this.field_11863, this.field_11867.method_10074(), (Object)class_2350.field_11036);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean motorTick(MotorEntity motor) {
        try (Transaction transaction = Transaction.openOuter();){
            switch (this.state) {
                case IDLE: {
                    this.tryStart((TransactionContext)transaction);
                    transaction.commit();
                    return false;
                }
                case FILLING: {
                    if (this.storage.getItemStorage().isEmpty()) {
                        this.interrupt();
                    }
                    this.progress = Math.min((float)this.maxProgress, this.progress + this.progressIncrement);
                    if (this.progress == (float)this.maxProgress) {
                        this.progress = 0.0f;
                        this.succeed((TransactionContext)transaction);
                        transaction.commit();
                    }
                    boolean bl = true;
                    return bl;
                }
                case EJECTING: {
                    class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseHorFacingBlock.field_11177);
                    if (this.storage.getItemStorage().isEmpty() || ItemPipeUtil.storageToAny((class_3218)this.field_11863, (Storage<ItemVariant>)this.storage.getItemStorage(), this.field_11867, facing, (TransactionContext)transaction)) {
                        this.state = State.IDLE;
                    }
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
    }

    void interrupt() {
        this.state = State.IDLE;
        this.progress = 0.0f;
        this.sync();
    }

    protected void tryStart(TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            if (this.moveToItem((TransactionContext)inner) > 0L) {
                this.state = State.FILLING;
                this.maxProgress = 5;
                this.startTime = this.field_11863.method_8510();
                this.sync();
                inner.abort();
            }
        }
    }

    protected void succeed(TransactionContext transaction) {
        this.moveToItem(transaction);
        this.state = State.EJECTING;
        this.sync();
    }

    private long moveToItem(TransactionContext transaction) {
        Storage<FluidVariant> inputStorage = this.getInputStorage();
        Storage<FluidVariant> outputStorage = this.storage.getFluidStorage();
        if (inputStorage != null && outputStorage != TransferApiImpl.EMPTY_STORAGE) {
            return StorageUtil.move(inputStorage, outputStorage, v -> true, (long)Long.MAX_VALUE, (TransactionContext)transaction);
        }
        return 0L;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static enum State {
        IDLE,
        FILLING,
        EJECTING;

    }
}

