/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.advanced_motor;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.api.pipe.AbstractBloodAcceptor;
import com.neep.neepmeat.transport.api.pipe.BloodAcceptor;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class AdvancedMotorBlockEntity
extends SyncableBlockEntity
implements MotorEntity {
    public float rotorSpeed = 1.0f;
    public float currentSpeed = 0.0f;
    public float angle;
    protected float influx;
    protected float loadTorque;
    @Nullable
    protected MotorisedBlock lastMotorised;
    protected final float maxInflux;
    @Nullable
    protected BlockApiCache<MotorisedBlock, Void> cache;
    protected final BloodAcceptor bloodAcceptor;

    public AdvancedMotorBlockEntity(class_2591<AdvancedMotorBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.maxInflux = (float)((Integer)NeepMeat.CONFIG.motors.advancedMotorMaxPower.getRealValue()).intValue() / (float)PowerUtils.BASE_POWER;
        this.cache = null;
        this.bloodAcceptor = new AbstractBloodAcceptor(){

            @Override
            public float updateInflux(float influx) {
                AdvancedMotorBlockEntity.this.influx = Math.min(influx, AdvancedMotorBlockEntity.this.maxInflux);
                AdvancedMotorBlockEntity.this.onPowerChange();
                return influx;
            }

            @Override
            public BloodAcceptor.Mode getMode() {
                return BloodAcceptor.Mode.SINK;
            }
        };
    }

    public void serverTick() {
        MotorisedBlock motorised;
        if (this.cache == null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseFacingBlock.field_10927);
            this.cache = BlockApiCache.create(MotorisedBlock.LOOKUP, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(facing));
        }
        if ((motorised = (MotorisedBlock)this.cache.find(null)) != null) {
            if (motorised.getLoadTorque() != this.loadTorque) {
                this.loadTorque = motorised.getLoadTorque();
                this.sync();
            }
            if (motorised != this.lastMotorised) {
                this.lastMotorised = motorised;
                this.onPowerChange();
            }
            motorised.motorTick(this);
        } else {
            this.lastMotorised = null;
        }
    }

    protected void onPowerChange() {
        MotorisedBlock motorised = this.getConnectedBlock();
        if (motorised != null) {
            motorised.setInputPower((float)this.getMechPUPower());
        }
        this.sync();
    }

    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.cache = null;
    }

    @Override
    public float getRotorAngle() {
        return this.angle;
    }

    @Override
    public MotorisedBlock getConnectedBlock() {
        return this.cache != null ? (MotorisedBlock)this.cache.find(null) : null;
    }

    @Override
    public double getMechPUPower() {
        return this.influx;
    }

    @Override
    public float getSpeed() {
        double power = PowerUtils.perUnitToAbsWatt(this.getMechPUPower());
        return (float)(power / (double)(this.loadTorque != 0.0f ? this.loadTorque : 300.0f));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("loadTorque", this.loadTorque);
        nbt.method_10548("influx", this.influx);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.loadTorque = nbt.method_10583("loadTorque");
        this.influx = nbt.method_10583("influx");
    }

    public BloodAcceptor getBloodAcceptor(class_2350 face) {
        return this.bloodAcceptor;
    }
}

