/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.advanced_integrator;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.ClientComponents;
import com.neep.neepmeat.api.DataResource;
import com.neep.neepmeat.api.data.DataUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class AdvancedIntegratorBlockEntity
extends SyncableBlockEntity {
    private final DataStorage storage = new DataStorage(this::sync);
    private final ClientComponents.Holder<AdvancedIntegratorBlockEntity> holder = new ClientComponents.BlockEntityHolder<AdvancedIntegratorBlockEntity>(this);

    public AdvancedIntegratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void onUse(class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43469((String)"message.neepmeat.integrator.data", (Object[])new Object[]{DataUtil.formatData(this.storage.getAmount()), DataUtil.formatData(this.storage.getCapacity())}), true);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        this.storage.writeNbt(nbt);
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        this.storage.readNbt(nbt);
        super.method_11014(nbt);
    }

    public DataStorage getDataStorage() {
        return this.storage;
    }

    public void serverTick() {
        if (this.storage.getAmount() < 8192L && this.field_11863.method_8510() % 4L == 0L) {
            try (Transaction transaction = Transaction.openOuter();){
                this.storage.insert(DataResource.NORMAL, 4L, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    public void clientTick() {
        this.holder.get().clientTick();
    }

    public static class DataStorage
    extends SingleVariantStorage<DataResource> {
        private final Runnable finalCallback;

        public DataStorage(Runnable finalCallback) {
            this.finalCallback = finalCallback;
        }

        protected void setAmount(long amount) {
            this.amount = amount;
        }

        protected DataResource getBlankVariant() {
            return DataResource.BLANK;
        }

        protected long getCapacity(DataResource variant) {
            return 16384L;
        }

        public long insert(DataResource insertedVariant, long maxAmount, TransactionContext transaction) {
            long insertedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
            if ((insertedVariant.equals(this.variant) || ((DataResource)this.variant).isBlank()) && this.canInsert(insertedVariant) && (insertedAmount = Math.min(maxAmount, this.getCapacity(insertedVariant) - this.amount)) > 0L) {
                this.updateSnapshots(transaction);
                if (((DataResource)this.variant).isBlank()) {
                    this.variant = insertedVariant;
                    this.amount = insertedAmount;
                } else {
                    this.amount += insertedAmount;
                }
                return insertedAmount;
            }
            return 0L;
        }

        public void readNbt(class_2487 nbt) {
            this.variant = DataResource.fromNbt(nbt.method_10562("variant"));
            this.amount = nbt.method_10537("amount");
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            this.finalCallback.run();
        }
    }
}

