/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item.util;

import com.google.common.collect.Iterators;
import com.neep.neepmeat.item.util.LivingTools;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class LivingItemStorage
extends SnapshotParticipant<Integer>
implements InsertionOnlyStorage<FluidVariant>,
StorageView<FluidVariant> {
    protected final class_1799 stack;
    protected final ContainerItemContext context;

    public LivingItemStorage(class_1799 stack, ContainerItemContext context) {
        this.stack = stack.method_7972();
        this.context = context;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        int fluidPerDurability = LivingTools.getFluidForDurability(insertedVariant);
        if (fluidPerDurability != -1) {
            long durabilityIncrease = Math.floorDiv(maxAmount, fluidPerDurability);
            durabilityIncrease = Math.min(durabilityIncrease, (long)this.stack.method_7919());
            long amountConsumed = Math.min(durabilityIncrease * (long)fluidPerDurability, maxAmount);
            if (durabilityIncrease > 0L) {
                this.updateSnapshots(transaction);
                this.stack.method_7974((int)((long)this.stack.method_7919() - durabilityIncrease));
                this.context.exchange(ItemVariant.of((class_1799)this.stack), 1L, transaction);
                return amountConsumed;
            }
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return true;
    }

    public FluidVariant getResource() {
        return FluidVariant.blank();
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return 0L;
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        return Iterators.singletonIterator((Object)((Object)this));
    }

    protected Integer createSnapshot() {
        return this.stack.method_7919();
    }

    protected void readSnapshot(Integer snapshot) {
        this.stack.method_7974(snapshot.intValue());
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return 0L;
    }
}

