/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.item.ClientBlockAttackListener;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatweapons.client.meatgun.animation.MeatgunAnimation;
import com.neep.meatweapons.client.meatgun.animation.PistolReloadMeatgunAnimation;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.init.MWComponents;
import com.neep.meatweapons.item.WeakTwoHanded;
import com.neep.meatweapons.item.meatgun.MeatgunAnimationManager;
import com.neep.meatweapons.item.meatgun.MeatgunItem;
import com.neep.meatweapons.meatgun.AmmunitionType;
import com.neep.meatweapons.meatgun.MeatgunCore;
import com.neep.meatweapons.meatgun.MeatgunModuleCapability;
import com.neep.meatweapons.meatgun.RootModuleCache;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.neepmeat.api.item.OverrideSwingItem;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.meatgun.animation.DrillPhageRayHoldMeatgunAnimation;
import com.neep.neepmeat.implant.entity.ImplantManager;
import com.neep.neepmeat.implant.item.ComplexityUpgradeImplant;
import com.neep.neepmeat.implant.item.ItemImplantManager;
import com.neep.neepmeat.implant.item.PneumaticMotorImplant;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.item.LivingToolApplicable;
import com.neep.neepmeat.meatgun.NMMeatgunModules;
import com.neep.neepmeat.meatgun.module.MiningMeatgunModule;
import com.neep.neepmeat.meatgun.module.RockDrillBaseModule;
import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_742;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RockDrillItem
extends MeatgunItem
implements ClientBlockAttackListener,
OverrideSwingItem,
LivingToolApplicable {
    public static final class_2960 CHANNEL_ID = new class_2960("rock_drill");
    private final RootModuleCache cache = new RootModuleCache();

    public RockDrillItem(TooltipSupplier tooltipSupplier, class_1792.class_1793 settings) {
        super(tooltipSupplier, settings.method_7889(1));
        FluidStorage.ITEM.registerForItems(this::getStorage, new class_1935[]{this});
    }

    private Storage<FluidVariant> getStorage(class_1799 stack, ContainerItemContext containerItemContext) {
        return new FoodStorage(containerItemContext);
    }

    @Override
    public WeakTwoHanded.ArmPose getThirdPersonArmPose(class_742 player, class_1799 stackInHand, class_1268 hand) {
        return WeakTwoHanded.ArmPose.CROSSBOW_HOLD;
    }

    @Override
    public boolean onSwing(class_1799 stack, class_1657 player) {
        return !((MeatgunComponent)MWComponents.MEATGUN.get((Object)stack)).getCore().canRun(player, 2);
    }

    @Override
    public boolean setEquipProgess() {
        return true;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    public boolean redirectTrigger(class_1799 stack, MeatgunModuleCapability trigger) {
        return this.getHead(stack).getCapabilities().contains((Object)trigger);
    }

    public static boolean using(class_1799 stack) {
        if (stack.method_7909() instanceof RockDrillItem && stack.method_7985()) {
            class_2487 nbt = stack.method_7969();
            return nbt.method_10577("attacking");
        }
        return false;
    }

    private static void onAttackPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean attacking = buf.readBoolean();
        server.execute(() -> {
            class_1799 mainStack = player.method_6047();
            if (mainStack.method_7909() instanceof RockDrillItem) {
                mainStack.method_7948().method_10556("attacking", attacking);
            }
        });
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        MeatgunModule meatgunModule = this.getHead(stack);
        if (meatgunModule instanceof MiningMeatgunModule) {
            MiningMeatgunModule mining = (MiningMeatgunModule)meatgunModule;
            mining.onBlockBroken(world, pos, state, miner);
        }
        return true;
    }

    private void sendAttack(boolean attacking) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(attacking);
        ClientPlayNetworking.send((class_2960)CHANNEL_ID, (class_2540)buf);
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        MeatgunModule meatgunModule = this.getHead(stack);
        if (meatgunModule instanceof MiningMeatgunModule) {
            MiningMeatgunModule mining = (MiningMeatgunModule)meatgunModule;
            return mining.isSuitableFor(state);
        }
        return super.isSuitableFor(stack, state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        MeatgunModule meatgunModule = this.getHead(stack);
        if (meatgunModule instanceof MiningMeatgunModule) {
            MiningMeatgunModule mining = (MiningMeatgunModule)meatgunModule;
            return mining.getMiningSpeedMultiplier(state);
        }
        return super.method_7865(stack, state);
    }

    public MeatgunModule getHead(class_1799 stack) {
        return ((RockDrillBaseModule)((MeatgunComponent)MWComponents.MEATGUN.get((Object)stack)).getRootHolder().root).getHead();
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        MeatgunComponent meatgun = (MeatgunComponent)MWComponents.MEATGUN.get((Object)stack);
        ImplantManager implants = meatgun.getRootHolder().coreImplants();
        implants.installImplant(PneumaticMotorImplant.ID);
        return stack;
    }

    @Override
    public void createDefaultTree(MeatgunModule root, RootModuleHolder.Listener listener) {
        if (root instanceof RockDrillBaseModule) {
            RockDrillBaseModule baseModule = (RockDrillBaseModule)root;
            baseModule.getHeadSlot().set((MeatgunModule)NMMeatgunModules.IRON_ROTARY_DRILL_HEAD.create(listener, root, NMItems.IRON_ROTARY_DRILL_HEAD.method_7854()));
        }
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Component component = NMComponents.IMPLANT_MANAGER.getNullable((Object)stack);
        if (component instanceof ItemImplantManager) {
            ItemImplantManager manager = (ItemImplantManager)component;
            tooltip.add((class_2561)class_2561.method_43470((String)"Core: ").method_10852((class_2561)class_2561.method_43471((String)manager.getCoreType().method_42093("implant"))).method_10862(class_2583.field_24360.method_36139(PLCCols.TEXT.col)));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public void onAttackBlock(class_1799 stack, class_1657 player) {
        if (!this.redirectTrigger(stack, MeatgunModuleCapability.ATTACK)) {
            this.sendAttack(true);
        }
    }

    @Override
    public void onFinishAttackBlock(class_1799 stack, class_1657 player) {
        this.sendAttack(false);
    }

    @Override
    public MeatgunModule createBase(RootModuleHolder.Listener listener) {
        return new RockDrillBaseModule(listener);
    }

    @Override
    public Supplier<Object> createAnimationManager() {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return new MeatgunAnimationManager(MeatgunAnimation.EMPTY).add("reload", new PistolReloadMeatgunAnimation()).add("phage_ray_hold", new DrillPhageRayHoldMeatgunAnimation());
            }
        };
    }

    @Override
    public int getMaxComplexity(class_1799 stack) {
        Component component = NMComponents.IMPLANT_MANAGER.getNullable((Object)stack);
        if (component instanceof ItemImplantManager) {
            ItemImplantManager manager = (ItemImplantManager)component;
            return ComplexityUpgradeImplant.getComplexity(16, manager);
        }
        return 16;
    }

    @Override
    public float getWorldHeightOffset() {
        return -0.2f;
    }

    @Override
    public RootModuleCache getCache() {
        return this.cache;
    }

    public int method_31571(class_1799 stack) {
        return 0xBB0000;
    }

    public boolean method_31567(class_1799 stack) {
        return ((MeatgunComponent)MWComponents.MEATGUN.get((Object)stack)).getCore().getResource() == AmmunitionType.METABOLIC;
    }

    public int method_31569(class_1799 stack) {
        MeatgunComponent component = (MeatgunComponent)MWComponents.MEATGUN.get((Object)stack);
        MeatgunCore core = component.getCore();
        return (int)(13.0 * (double)core.getAmount() / (double)core.getCapacity());
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, RockDrillItem::onAttackPacket);
    }

    public record FoodStorage(ContainerItemContext context) implements Storage<FluidVariant>
    {
        private class_1799 getStack() {
            return this.context.getItemVariant().toStack((int)this.context.getAmount());
        }

        public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedResource, (long)maxAmount);
            class_1799 stack = this.getStack();
            long inserted = ((MeatgunComponent)MWComponents.MEATGUN.get((Object)stack)).getCore().acceptResource(insertedResource, maxAmount, transaction);
            this.context.exchange(ItemVariant.of((class_1799)stack), 1L, transaction);
            return inserted;
        }

        public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        @NotNull
        public Iterator<StorageView<FluidVariant>> iterator() {
            return Collections.emptyIterator();
        }
    }
}

