/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.guide;

import com.neep.neepmeat.client.screen.tablet.GuideScreen;
import com.neep.neepmeat.guide.GuideReloadListener;
import com.neep.neepmeat.guide.article.Article;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public interface GuideNode {
    public static final GuideNode BACK = new GuideNode(){

        @Override
        public List<GuideNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(GuideNode node) {
        }

        @Override
        public String getId() {
            return "";
        }

        @Override
        public class_2960 getIcon() {
            return new class_2960("minecraft:empty");
        }

        @Override
        public class_2561 getText() {
            return class_2561.method_30163((String)" \u2190");
        }

        @Override
        public void visitScreen(GuideScreen screen) {
            screen.pop();
        }
    };

    public List<GuideNode> getChildren();

    public void addChild(GuideNode var1);

    public String getId();

    public class_2960 getIcon();

    public class_2561 getText();

    public void visitScreen(GuideScreen var1);

    public static class ArticleNode
    extends GuideNodeImpl {
        private final Set<String> lookups;

        public ArticleNode(String id, Set<String> lookup, class_2960 icon, class_2561 text) {
            super(id, icon, text);
            this.lookups = new HashSet<String>(lookup);
        }

        @Override
        public List<GuideNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(GuideNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitScreen(GuideScreen screen) {
            Article article = GuideReloadListener.getInstance().getArticle(this.getId());
            GuideReloadListener.getInstance().setPersistentArticle(article);
            screen.openArticle(article);
        }

        public boolean matchesLookupTerm(String term) {
            return this.lookups.contains(term);
        }

        public void addLookupTerm(String term) {
            this.lookups.add(term);
        }
    }

    public static class MenuNode
    extends GuideNodeImpl {
        private final List<GuideNode> children;

        public MenuNode(String id, class_2960 icon, class_2561 text, List<GuideNode> children) {
            super(id, icon, text);
            this.children = children;
        }

        @Override
        public List<GuideNode> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(GuideNode node) {
            this.children.add(node);
        }

        @Override
        public void visitScreen(GuideScreen screen) {
            screen.push(this);
        }
    }

    public static abstract class GuideNodeImpl
    implements GuideNode {
        private final String id;
        private final class_2960 icon;
        private final class_2561 text;

        public GuideNodeImpl(String id, class_2960 icon, class_2561 text) {
            this.id = id;
            this.icon = icon;
            this.text = text;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public class_2960 getIcon() {
            return this.icon;
        }

        @Override
        public class_2561 getText() {
            return this.text;
        }

        public boolean equals(Object other) {
            if (other instanceof GuideNode) {
                GuideNode node = (GuideNode)other;
                return Objects.equals(node.getId(), this.getId());
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

